\ 25_delays_140502.fs -- 25 MHz delays -- 140502rjn
\ delays and tests for chips running at a nominal 25 MHz clock
\

] ( target)  here  ( * start)
\ 
\ --------------[ these delays may be defined in bootloader ]------------------
\
\ small delays using various registers -- 2 cycles/iteration
:m delay2    ( n -)  2 #for  2 #next m;
:m delay3    ( n -)  3 #for  3 #next m;
:m delay4    ( n -)  4 #for  4 #next m;
:m delay5    ( n -)  5 #for  5 #next m;
:m delay6    ( n -)  6 #for  6 #next m;
:m delay7    ( n -)  7 #for  7 #next m;

\ ~ 350 ns for 1 # delay7 (250 # delay3 is ~88 usec)
:m #delay  ( n -)   delay7 m;  \ 3 cycles + 2 cycles/iteration

:m delay765  ( n -)   \ ~8.1 ms with n=1 and 24.5 MHz clock
      7 #for
         0 # 6 #for 0 # delay5 6 #next
      7 #next m;
\ 
\ 
:m |us  ( n - )   
   7 #for  
      6 #  6 #for 6 #next  
   7 #next m;
\ 100 # us -> 90 usec ( adding nop in inner loop -> 114 usec)

-: us  ( n - )   [ 7 push  6 push ]  |us  [ 6 pop  7 pop ] ;

:m |ms  ( n - )   
   7 #for 
      100 #  6 #for 
         81 #  5 #for 5 #next 
      6 #next 
   7 #next m;
-: ms  ( n - )   [ 7 push  6 push  5 push ]  |ms  [ 5 pop  6 pop  7 pop ] ;
\
\ 
0 [if] \ -------------------[ double number raw delay ]------------------------
 
   1. Double number delay (100 ## ##delay =~ 229 usec)
   2. Note that an interrupt service delay may interfere significantly with 
      this delay routine at low microsecond values.

[then] \ ----------------------------------------------------------------------

:m ##delay  ( d - )   \ double number delay
  0 # begin 
     drop -1 ## |d+ |over |over 
  ior 0=until drop drop drop m;
\ 
\ 
0 [if]  \ -----[ tests ]

\ Example: assumes port/pin is setup correctly -- port/pin may vary

:m /delays  $ff # P0MDOUT ior! m;

:m pin0  0 .P0 m;
:m low   [ pin0 set ] m;
:m high  [ pin0 clr ] m;
:m ~pin  [ pin0 toggle ] m;

\ 9.8 us, 50.99 kHz -- 24.57538 MHz crystal
: test1   begin  ~pin  10 # us  again

\ 9.8 us & 45.49 us, 18.0843 kHz -- 24.57538 MHz crystal
: test2   begin  10 # us high  50 # us low  again

\ 10.05 ms per half cycle, 49.73 Hz -- 24.57538 MHz crystal
: test3   begin  10 # ms high  10 # ms low  again

\ 8.1 ms per half cycle, 62.18 Hz -- 24.57538 MHz crystal
: test4  begin ~pin 1 # delay765 again

\ 360 ns per half cycle, 1.36536 MHz -- 24.57538 MHz crystal
: test-delay  begin  ~pin  1 # delay3 again

\ 204 ns per half cycle, 2.45765 MHz -- 24.57538 MHz crystal
: fastest     begin  ~pin again

\ positive width is 229 useconds 
: ddtest1   begin 100 ## ##delay ~pin again

[then] \ ----------------------------------------------------------------------
\
\
0 [if] ------------------------------[ notes ]---------------------------------

1. Decompilation:

---------- test-delay
070B B2 80       cpl 80.0
070D 7B 01       mov R3,#01 #!
070F DB FE       djnz R3,070F #next
0711 E1 0B       ajmp 070B test-delay
---------- fastest
0713 B2 80       cpl 80.0
0715 E1 13       ajmp 0713 fastest

2. Code above generated with sees.bat: sees 6 test-delay > delays.txt,
   and results copied and pasted here from the file.

------------------------------------------------------------------------ [then]
\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( 25_delays_140502.fs     ) . .( bytes) [else] drop [then] 
]
\ 
\ 
0 [if] ------------------------------[ revisions ]-----------------------------

Date	   By  Comment
=======	=== ==============================================================
140502   rjn added revision number, copied to library
10Aug13  rjn changed for compilation summary
21Feb09  rjn utility version, not processor specific, just clock freq.
09Feb09  rjn original version, cloned from 310 delays

------------------------------------------------------------------------ [then]
