\ 4432_functions.fs -- Initialize 4432 chip -- 140813rjn
\ 
] here ( *start)
\ 
\ Notes:
\ 1. see AN440 for detailed register descriptions
\ 2. see rafl_strings.fs for string definitions
\ 
-: 4432_reset  [ sdn set ]  10 # |ms  [ sdn clr ]  200 # |ms ;
\ 
\ -----[ device type and status ]
\ 
\ -: @ds    ( - n)         2 # read     ;  \ for application processing
\ -: .dst    ( -)   'ds          @ds  h. ;  \ device status
\ -: .dtp    ( -)   'dt     0 # read  h. ;  \ device type ($08 for EZ RadioPRO)
\ 
\ -----[ interrupts ]
\ 
-: @i_stat1   ( - n)   3 # read ;  \ interrupt status 1
-: @i_stat2   ( - n)   4 # read ;  \ interrupt status 2

-: !ie1  ( n -)   $05 # write ; 
-: !ie2  ( n -)   $06 # write ;  

-: /interrupt   @i_stat1 drop  @i_stat2 drop ;
-: -interrupts      0 #  !ie2 ;    \ disable interrupts

-: +packet_sent_int   $04 #  !ie1 ;
-: +packet_rcvd_int   $02 #  !ie1 ;
\ 
\ -----[ function control ]
-: !fc1  ( n -)   $07 # write ;    \ operating mode and fx ctl 1
-: !fc2  ( n -)   $08 # write ;    \ function control 2 (fifo clear bits)
\ 
\ -----[ xtal load capacitance ]
-: !xlc  ( n -)   $09 # write ;    \ crystal load capacitance
-: stabilize_osc   5 # |ms ;
\ 
\ -----[ transmit and receive modes ]
-: tx_mode      $09 #  !fc1 ;   \ enter transmit mode
-: rx_mode      $05 #  !fc1 ;   \ enter receive mode

\ -: ready_mode   $01 #  !fc1 ;   \ ready mode
-: ready_mode+  $41 #  !fc1 ;   \ ready mode + battery detect
\ 
\ -----[ fifo management ]
\ 
cpuHere constant #fifo 1 cpuAllot  \ number of bytes in fifo

-: /#fifo   0 # #fifo #! ;
-: +#fifo  [ #fifo inc ] ;
-: @#fifo  #fifo #@ ;

-: /fifo  $03 # !fc2  0 # !fc2  /#fifo ;
-: @fifo    ( - n)   $7f # read   +#fifo ;
-: (!fifo)  ( n -)   $7f # write ;
-: !fifo  ( n -)  (!fifo)  +#fifo ;

-: .#fifo  'snt @#fifo h. ;
\ 
\ -----[ afc loop settings ]
-: !afc  ( n -)  $1d # write ;   \ afc loop settings
\ 
\ -----[ data access control ]
-: !dac  ( n -)  $30 # write ;   \ data access control (PH, CRC, etc.)
\ 
\  -----[ header control ]
-: !hc1  ( n -)  $32 # write ;   \ header control 1
-: !hc2  ( n -)  $33 # write ;   \ header control 2 (default $22)
\ 
\ -----[ received header ]
\ -: .rh  ( -)   'hdr   
\   $4a # read h.  $49 # read h.  $48 # read h.  $47 # read h. ;
\ 
\ -----[ antenna switching ]
-: >tx_ant      $01 #  $0e # write ;   \ ant. switch in Tx mode
-: >rx_ant      $02 #  $0e # write ;   \ ant. switch in Rx mode

-: !payload  ( n -)    $3e # write ;   \ write payload size 

-: !tx_preamble  ( n -)   $34 # write ;   \ write preamble size

\ valid only if bit D3 of HC2 is cleared
-: plen  ( - n)   $4b # read ;         \ length of received packet
\ 
\ -----[ rssi ]
-: @rssi  ( - n)   $26 # read ;
\ -: .rssi   ( -)   'rss  @rssi  h. ;
\ 
\ -----[ battery voltage ]
-: @vb  ( - n)   $1b # read ;  \ read battery voltage
\ -: .vbat  ( -)   'vbat  @vb  h. ;  \ battery voltage (1.5+vbat*50mv)
\ 
\ -----[ version code ]
-: @vc  ( - n)     1 # read ;
\ -: .vc    ( -)   'ver  @vc  h. ;  \ version code, 4432, Rev. B1 = 6
\ 
-: 4432_init  \ mostly from DORJI code example
   /4432  4432_reset
\   
\  data/cmd       adr               comment
\  --------       -----             -------------------------------------------
   /interrupt                       \ clear interrupt
   -interrupts                      \ disable interrupts
   ready_mode+                      \ ready mode, enable battery detect
\   $7f # !xlc                       \ xtal load cap = 12 pf (default)
   $05 #          $0a # write       \ output clock = 2 MHz, no enlfc
   $ea #          $0b # write       \ gpio0 = direct digital output
   $ea #          $0c # write       \ gpio1 = direct digital output
   $f4 #          $0d # write       \ gpio2 = Rx data (output)
\ 
\ -----[ from Excel Spreadsheet ]
   $40 # !afc                       \  enable AFC
\    
\ -----[ 1.2K bps setting ]
   $16 #          $1c # write           
   $83 #          $20 # write        
   $c0 #          $21 # write
   $13 #          $22 # write
   $a9 #          $23 # write
   $00 #          $24 # write
   $04 #          $25 # write
   $14 #          $2a # write
   $09 #          $6e # write
   $d5 #          $6f # write
   $2c #          $70 # write       \ 
\ 
\ === end 1.2K setting
\ 
   $8c #  !dac                      \ PH+fifo, MSB, CRC enabled
   $ff #  !hc1                      \ header control 1: header= byte 0,1,2,3
   $42 #  !hc2                      \ header control 2: 
                                    \ sync=3,2; packet len enabled; 
                                    \ header length = 3,2,1,0
    16 #  !tx_preamble              \ Tx preamble = 16 nibbles
   $20 #          $35 # write       \ detected preamble = 4 nibbles  ??????
\ 
\ ----- synch word = $2dd4 (default)
\   $2d #          $36 # write       \ synch. word 3 (default= $2d)
\   $d4 #          $37 # write       \ synch. word 2 (default= $d4)
\   $00 #          $38 # write       \ synch. word 1 (default= 0)
\   $00 #          $39 # write       \ synch. word 0 (default= 0)
\ 
\ ----- Tx header
   [ char s ] #   $3a # write       \ Tx header = 'swwx'
   [ char w ] #   $3b # write
   [ char w ] #   $3c # write
   [ char x ] #   $3d # write
\ 
\ ----- payload size
\   10 # !payload                    \ payload = 10 bytes
\ 
\ ----- check header
   [ char s ] #   $3f # write       \ check header = 'swwx'
   [ char w ] #   $40 # write
   [ char w ] #   $41 # write
   [ char x ] #   $42 # write
\ 
\ ----- enable header check
\   $ff #          $43 # write       \ header enable 3 (default= $ff)
\   $ff #          $44 # write       \ header enable 2 (default= $ff)
\   $ff #          $45 # write       \ header enable 1 (default= $ff)
\   $ff #          $46 # write       \ header enable 0 (default= $ff)

   $07 #          $6d # write       \ max power
   $00 #          $79 # write       \ no hopping
   $00 #          $7a # write       \ "   "
   $22 #          $71 # write       \ RF mode = FSK, FiFo
   $30 #          $72 # write       \ frequency deviation = 30 kHz
   $00 #          $73 # write       \ no frequency offset
   $00 #          $74 # write       \ "      "       "
   $53 #          $75 # write       \ frequency = 433.5 MHz
   $57 #          $76 # write       \ 
   $80 #          $77 # write       \ 
;

\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( 4432_functions.fs      ) . .( bytes) [else] drop [then] 
]
\
\
0 [if] ---------------------[ Revision History ]-------------------------------
\ 
Date	  By  Description
======= === ===================================================================
140829  rjn added @vb, @v
140813  rjn misc. cleanup, moved fifo management here
140803  rjn added received packet length (plen)
140729  rjn named parameter loading, dynamic checksum
140728  rjn tx and rx work!
140724  rjn added reset and rss
140723  rjn initial version, startup sequence copied from code example
\ 
[then] \ ----------------------------------------------------------------------
