\ 4432_spi.fs -- RAFL spi driver -- 140922rjn
\ 
] here ( *start)
\
\ 
0 [if] \ ------------------------[ RAFL I/O ]----------------------------------
\
\ these are defined in rafl_init.fs, shown here for code readability
\ 
:m sclk  [ 0 .p1 ] m; \ PP SCLK
:m mosi  [ 1 .p1 ] m; \ PP to SDI
:m miso  [ 2 .p1 ] m; \ DI from SDO
:m nsel  [ 4 .p1 ] m; \ PP chip select
:m nirq  [ 5 .p1 ] m; \ DI from irq line
:m sdn   [ 6 .p1 ] m; \ PP shutdown (1=shutdown, 0=power up)
:m gpio0 [ 0 .p0 ] m; \ DI from 4432
:m gpio1 [ 1 .p0 ] m; \ DI from 4432
:m gpio2 [ 2 .p0 ] m;
\ 
[then] \ ----------------------------------------------------------------------
\ 
:m /4432  [ sclk clr ]  [ nsel set ]  [ mosi clr ] m;
\ 
0 [if] \ ------------[ SPI Timing per 4432 Datasheet ]-------------------------
\ 
1. sclk is low to high, 40 ns minimum on both high and low.  
   Starts low, ends low (20 ns minimum before start of next).
2. nSEL high to low to start.  Must remain low 20 ns prior to first clock.
   Pull high after last data bit is set.
3. adr and data are sent msb first. 
4. Maximum rate is 10 MHz.
5. Burst mode sends multiple bytes preceded by a single adr for loading the
   fifos.  This mode is used for single bytes with a byte count of 1.
6. MSB of adr is 1 for write, 0 for read.

[then] \ ----------------------------------------------------------------------
\ 
0 [if] \ ----------------------[ checksum ]------------------------------------
\ 
cpuHere constant checks 1 cpuAllot  \ accumulates checksum

: /check  0 # checks #! ;
: @check  ( - n)   checks #@ ;  
\ : +check  ( n -)   @check  +  checks #! ;  \ add to checksum
:m +check  [ t push  checks add  t checks mov  t pop ] m;
: .check  @check h. ;
\ 
[then] \ ----------------------------------------------------------------------
\ 
\ -----[ send a byte to 4432 ]
\ 
-: do-byte  ( n - n')  \ send/rcv byte, most significant bit first
   8 # 7 #for
      [ rlc mosi movcb ]   \ msb from T to mosi
      nop nop   \ min data setup is 20 ns -- allow ~80
      [ sclk set ]  nop nop [ sclk clr ]  \ data out clocks low->high
      nop nop [ miso movbc ]  \ data in ready after high->low
   7 #next ;

-: spi-adr   [ nsel clr ] nop nop do-byte drop ;

:m !spi-bytes  ( ... n -)  4 #for ( +check) do-byte drop 4 #next [ nsel set ] m; 
:m @spi-bytes  ( n - ...)  4 #for 0 # do-byte 4 #next [ nsel set ] m; 

-: bwrite  ( ... cnt adr -)   $80 # ior  spi-adr  !spi-bytes ;   \ burst write
-: write   ( n adr -)   1 # swap bwrite ;

-: bread  ( cnt adr - ...)   spi-adr  @spi-bytes ;   \ burst read
-: read   ( adr - n)   1 # swap bread ;
\ 
\ 
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( 4432_spi.fs             ) . .( bytes) [else] drop [then] 
]
\
\
0 [if] ---------------------[ Revision History ]-------------------------------
\ 
Date	  By  Description
======= === ===================================================================
140922  rjn changed several words to be "non-user"
140730  rjn checksum now part of do-byte
140726  rjn refactored read and write.  bread and bwrite still don't work
140725  rjn changed to read and write vs. send and receive
140723  rjn coded send, receive
140722  rjn cloned from 9850.fs
\ 
[then] \ ----------------------------------------------------------------------
