\ dacs_qdigits.fs -- display quad in prod as decimal digits -- 140521rjn
\ 
]  here ( *start)
\ 
\ -----[ decimal digit extraction ]
\ 
0 [if] \ ----------------------[ Decimal Conversion ]--------------------------

1.    ----- Decimal/Hex equivalents -----

 	   Decimal      Hexadecimal    
        =============   ==============
      100,000,000,000   17 48 76 E8 00 (not needed)
       10,000,000,000   02 54 0B E4 00 (not needed)
        1,000,000,000   00 3B 9A CA 00
          100,000,000   00 05 F5 E1 00           
           10,000,000   00 00 98 96 80
            1,000,000   00 00 0F 42 40
              100,000   00 00 01 86 A0
               10,000   00 00 00 27 10             
                1,000   00 00 00 03 E8
                  100   00 00 00 00 64
                   10   00 00 00 00 0A

2. Changed to display up to $efffffff = 4,026,531,839. -- 01Nov13 rjn  

3. The value to be converted is assumed to be in the prod, the double quad
   (64-bit) register used for multipication results (see multiply.fs).

[then] \ ----------------------------------------------------------------------
\ 
cpuHERE constant dig0 16 cpuALLOT  \ dig0 is MSB, dig 7 + is LSB
\ 
:m dig1   [ dig0 1 + ] m;
:m dig2   [ dig0 2 + ] m;
:m dig3   [ dig0 3 + ] m;

:m dig4   [ dig0 4 + ] m;
:m dig5   [ dig0 5 + ] m;
:m dig6   [ dig0 6 + ] m;
:m dig7   [ dig0 7 + ] m;
\ 
\ leading zero processing
cpuHERE constant -leader? 1 cpuALLOT  \ 0 = a leading zero
:m lead0     0 # -leader? #! m;
:m -lead0  $ff # -leader? #! m;
\ 
\ decimal point placement
cpuHERE constant dp 1 cpuALLOT  \ holds current digit index
:m 1dp    1 # dp #! m;  
:m 2dp    2 # dp #! m;  
:m 3dp    3 # dp #! m;  
:m 4dp    4 # dp #! m;  
:m 5dp    5 # dp #! m;  
:m 6dp    6 # dp #! m; 
:m 7dp    7 # dp #! m;  
:m 8dp    8 # dp #! m;  
:m 9dp    9 # dp #! m;  
:m 10dp  10 # dp #! m;  

\ 
\ -----[ Add, Subtract decimal scaling to/from prod ]
\ 
\ use dig registers to hold the current digit multiplier
\ 
-: |prod+dig  \ use only prod4 (msb) to prod7 (lsb) -- convert quad part only
	[ t push  clrc
      prod7 t mov  dig3 addc  t prod7 mov
      prod6 t mov  dig2 addc  t prod6 mov
      prod5 t mov  dig1 addc  t prod5 mov
      prod4 t mov  dig0 addc  t prod4 mov
   t pop ] ;

-: |prod-dig
	[ t push  clrc
      prod7 t mov  dig3 subb  t prod7 mov
      prod6 t mov  dig2 subb  t prod6 mov
      prod5 t mov  dig1 subb  t prod5 mov
      prod4 t mov  dig0 subb  t prod4 mov
   t pop ] ;
\ 
1 [if] \ -------------[ get digit multipliers from table ]---------------------
\ 
\ note: now use @qflash defined in send-flash.fs -- 21Apr13 rjn
\ returns four bytes in the same order as stored in flash (e.g., lsb on tos)
\ -: @qflash  ( d - q)   p!  |@p+ |@p+ |@p+ |@p ;
\ : .qtable   ( table-adr -)       p!  4 #  5 #for |@p+ h. 5 #next ;
\ 
here constant digit-table
\ lsb ------------- msb
   $00 , $CA , $9A , $3B ,
   $00 , $E1 , $F5 , $05 , 
   $80 , $96 , $98 , $00 ,
   $40 , $42 , $0F , $00 , 
   $A0 , $86 , $01 , $00 , 
   $10 , $27 , $00 , $00 ,
   $E8 , $03 , $00 , $00 ,
   $64 , $00 , $00 , $00 ,
   $0A , $00 , $00 , $00 ,
   $01 , $00 , $00 , $00 ,
here digit-table [ -  4 / ] constant #digs  

cpuHere constant dig#  1 cpuALLOT  \ non-zero if a digit has been displayed
-: 0dig#  0 # dig# #! ;
-: +dig#   [ dig# inc ] ;

\ returns four bytes in the same order as stored in flash (e.g., lsb on tos)
-: @qflash  ( da - q)   p!  |@p+ |@p+ |@p+ |@p ;

\ note: index must be less than 64
-: ai>qadr  ( da i - d')  2* 2* 0 # |d+ ;  \ compute table adr from index

-: ndigit  ( index -)  \ load dig0 from table
   push digit-table ##  pop  ai>qadr @qflash  dig0 # !quad ;
\ 
[then] \ ----------------------------------------------------------------------
\ 
-: (qdigit)  ( - n)  
   1 # negate dup begin drop |prod-dig 1+ prod4 #@ -until drop |prod+dig ;

-: ?.digit  ( n -)  \ suppress leading zeroes 
   dup -leader? #@ ior 0=if drop drop ( space ) ; then drop -lead0  digit +dig# ;

\ 
0 [if] \ ------------------[ convert all digits ] -----------------------------
\ 
-: .qdigits  \ various routines, driven by a selector.  Select routine with gp15
   lead0  \ set leading zero suppression flag
   [ 4 push ]   
        0 #  #digs #  4 #for 
           dup dp #@ xor 0=if [ char . ] # emit then drop
           dup ndigit (qdigit) ?.digit  1+ 
        4 #next  drop  
   [ 4 pop ] ;
\ 
\ -: @prod<  ( - q)   prod4 # @quad<  ;
\ -: !prod   ( q -)   prod4 # !quad   ; 
\ -: (.qdigits)  @prod< .qdigits !prod ;  
\ 
[then] \ ----------------------------------------------------------------------
\ 
-: ?lead0  dig# #@ 0=if [ char 0 ] # emit -lead0 then drop ;
-: ?.qdigits  ( n -)  \ display n digits of value in prod
   lead0  \ set leading zero suppression flag
   0dig#  \ clear "# digits displayed"
\   space
   [ 4 push ]   
        0 #  swap  4 #for 
\           dup dp #@ xor 0=if [ char . ] # emit then drop
           dup dp #@ xor 0=if ?lead0  [ char . ] # emit then drop
           dup ndigit (qdigit) ?.digit  1+ 
        4 #next  drop  
   [ 4 pop ] ;
;
\ 
0 [if] \ -------------------------[ tests ]------------------------------------
\ these work -- 01Nov13 rjn 
: 1qdt   0prod  2dp  \ display max number: $7fffffff = 2,147,483,647
   $ff # prod7 #!  $ff # prod6 #!  $ff # prod5 #!  $7f # prod4 #!  .qdigits ; 
: 2qdt   0prod  3dp  \ display decimal number: $7fffffff = 1,234,567,890
   $d2 # prod7 #!  $02 # prod6 #!  $96 # prod5 #!  $49 # prod4 #!  .qdigits ; 
\    
[then] \ ----------------------------------------------------------------------   
\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( dacs_qdigits.fs        ) . .( bytes) [else] drop [then]
]
\ 
0 [if] \ ------------------------[ revisions ]---------------------------------
\ 
Date     By    Comment
=======	===   ================================================================
140523   rjn   eliminated leading space on numbers (do in display routines)
140521   rjn   changed space formatting in ?.qdigits and ?.digit
140502   rjn   add rev number and put in library (still custom for dacs)
01Nov13  rjn   changed for dacs
16Jun13  rjn   copied from sudds for decimal display of freq.
\ 
[then] \ ----------------------------------------------------------------------
