\ dis5x-1.fs  -- MyForth 8051 disassembler -- 14Sep08

0 [if]
Copyright (C) 2004 by Charles Shattuck.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL information:   http://www.gnu.org/copyleft/lesser.txt

[then]

only forth also definitions

\ Default decoder, for debugging.
: bad   (  - )   true abort" Opcode not supported";

\ Make a 256 word table of words that describe an opcode.
\ At first the table is filled with "bad" words.

: bad-fill  ( -)   256 0 DO ['] bad , LOOP ;
create 'dis
\        ' bad , 256 times
bad-fill

\ Display a single digit, used for bits.
: .X   ( b - )   $30 + emit ;

\ Display a byte as 2 hexadecimal digits, no trailing space.
: .XX|   ( b - )
        base @ >r   hex 0 <#   # #   #> type   r> base ! ;

: .XX   ( b - )   .XX| space ;

\ Display an address as 4 hexadecimal digits.
: .XXXX   ( b - )
        base @ >r   hex 0 <#   # # # #   #> type space   r> base ! ;

\ Show the single byte at a1 and return a+1.
: .byte   ( a1 - a2)   dup 1+ swap c@-t .XX ;

\ Show the hex byte of a single byte instruction.
: .1byte    ( a1 - a2)   .byte 9 spaces ;

\ Show the hex bytes of a two byte instruction.
: .2bytes   ( a1 - a2)   .byte .byte 6 spaces ;

\ Show the hex bytes of a three byte instruction.
: .3bytes   ( a1 - a2)   .byte .byte .byte 3 spaces ;

\ Decodes a single instruction.
: (decode)   ( a1 - a2)   dup c@-t cells 'dis + @ execute ;

: dashes  ( n - )  0 ?do  [char] - emit  loop ;

nowarn
: show-name  ( a - )
	>red label? dup if  cr 10 dashes space dup show  then
	drop >black ;
warn

: decode-all   (  - )
	0 begin
		dup show-name
		cr dup .XXXX (decode)
		dup ] HERE [ < 0=
	until  drop ;

: decodes  ( n a - )
	swap 0 do
		dup show-name
		cr dup .XXXX (decode)
	loop  drop ;

nowarn
\ Decodes multiple instructions.  Press a key for each instruction.
: decode  ( a - )
	begin
		dup show-name
		cr dup .XXXX (decode) key dup 27 = swap [char] q = or
	until  drop >black quit ;
warn

\ : see   (  - )   also target ' >body @ decode previous ;

\ ----- Fill the 'dis array.

create 'viewer   ' .1byte ,   ' .2bytes ,   ' .3bytes ,

: viewer   ( n - )   1 - 0 max 2 min cells 'viewer + @ ;

: bytes   ( n - )   >blue viewer execute >green ;

: op   ( n1 n2 - )   cells 'dis + >r   viewer r> ! ;

\ : d:   ( opcode - )   here swap cells 'dis + ! : ;
: d:   ( opcode - )   :noname swap cells 'dis + ! ;
: dis!   ( opcode addr - )   swap cells 'dis + ! ;

: .#   ( a - )   1 - c@-t .XX| ;

: .label  ( a - )
	$ffff and
	dup base @ >r hex 0 <# # # # # #> type r> base !
	label? dup if  space dup show  then drop >black ;

: .relative   ( a - )
        dup 1 - c@-t
        dup $80 and if  $FF00 or   then  + .label ;
\ 
0 [if] --------------------------[ notes ]-------------------------------------
 
1. .absolute has problems -- versions tagged original, 14Sep08 & 19Mar09
   work for some cases, not others.
2. The first line can't reconstruct addresses above $0FFF.  The alternative
   line dated 19Mar09 helps for addresses in the $08xx-$0Fxx range, but can't 
   decode lower addresses such as those in the $02xx-$07xx range 
   (and probably lower).
3. Workaround:
	+ For addresses above $0FFF, probably nothing can be done in .absolute
          because the full address of the assembled instruction is needed and
          it can't be reconstructed from the assembled instruction -- it
          requires the address where the instruction is assembled.
	+ For addresses in the $02xx-$07xx range, use the original #1 version
        + For addresses in the $08xx-$0Fxx range, use the 19Mar09 version
        + Use the 14Sep08 version for most cases, but try original #2 if you
	  can't get a good decode after selecting the "top line" version
          for your range (i.e., original #1 or 19Mar09).  
4. This version is modified from the 1/29/2008 9:30 version of dis5x.fs

------------------------------------------------------------------------ [then]
\ 
: .absolute   ( a - )
\   dup 2 - c@-t ( bits 10, 9, 8) 2/ 2/ 2/ 2/ 2/ 7 and 8 or 8 lshift  >r  \ 19Mar09 rjn
    dup 2 - c@-t ( bits 10, 9, 8) 2/ 2/ 2/ 2/ 2/ 7 and      8 lshift  >r  \ original #1
  1 - c@-t r> or ( over $fc00 and or) .label ;  \ 14Sep08 rjn
\  1 - c@-t r> or over $fc00 ( $f800) and or .label ;     \ original #2

\ : .long  ( a - ) dup 1 - c@-t .label ;
: .long   ( a - )
	dup 2 - c@-t ( 256 *) 8 lshift swap 1 - c@-t or .label ;

: .bit   ( a - )
        c@-t   dup $80 < if
                \ Show a bit in the bit addressable memory locations.
                0 8 um/mod $20 + .XX| S" ." type .X
        else    \ Show a bit in the Special Function Register locations.
                dup 8 mod swap $F8 and
                dup $F0 = if   S" B."    type drop .X exit   then
                dup $E0 = if   S" ACC."  type drop .X exit   then
                dup $D0 = if   S" PSW."  type drop .X exit   then
                dup $B8 = if   S" IP."   type drop .X exit   then
                dup $B0 = if   S" P3."   type drop .X exit   then
                dup $A8 = if   S" IE."   type drop .X exit   then
                dup $98 = if   S" SCON." type drop .X exit   then
                dup $90 = if   S" P1."   type drop .X exit   then
                dup $88 = if   S" TCON." type drop .X exit   then
                .XX| S" ." type .X
        then    ;

: .direct   ( a - )
        c@-t
        dup $F0 = if   S" B"    type drop exit   then
        dup $E0 = if   S" ACC"  type drop exit   then
        dup $D0 = if   S" PSW"  type drop exit   then
        dup $B8 = if   S" IP"   type drop exit   then
        dup $B0 = if   S" P3"   type drop exit   then
        dup $A8 = if   S" IE"   type drop exit   then
        dup $98 = if   S" SCON" type drop exit   then
        dup $90 = if   S" P1"   type drop exit   then
        dup $88 = if   S" TCON" type drop exit   then
        dup $99 = if   S" SBUF" type drop exit   then
        dup $89 = if   S" TMOD" type drop exit   then
        dup $8A = if   S" TL0"  type drop exit   then
        dup $8B = if   S" TL1"  type drop exit   then
        dup $8C = if   S" TH0"  type drop exit   then
        dup $8D = if   S" TH1"  type drop exit   then
        dup $81 = if   S" SP"   type drop exit   then
        dup $82 = if   S" DPL"  type drop exit   then
        dup $83 = if   S" DPH"  type drop exit   then
        dup $87 = if   S" PCON" type drop exit   then
        .XX| ;

: .,   (  - )   [char] , emit ;

nowarn

$00 :noname ( .nop)    ( a1 - a2)   1 bytes S" nop" type ; dis!
$01 :noname ( .ajmp)   ( a1 - a2)
   2 bytes S" ajmp "  type dup .absolute >black ."  ;" ; dis!
$02 :noname ( .ljmp)   ( a1 - a2)
   3 bytes S" ljmp " type dup .long >black ."  ;" ; dis!
$03 :noname ( .rr)     ( a1 - a2)   1 bytes S" rr A" type ; dis!
$04 :noname ( .inc)    ( a1 - a2)
   1 bytes S" inc A" type >black ."  1+" ; dis!
$05 :noname ( .inc)    ( a1 - a2)   2 bytes S" inc " type dup 1 -
.direct ; dis!
$06 :noname ( .inc)    ( a1 - a2)
   1 bytes S" inc @R0" type >black ."  u1+" ; dis!
$07 :noname ( .inc)    ( a1 - a2)   1 bytes S" inc @R1" type ; dis!
$08 :noname ( .inc)    ( a1 - a2)
   1 bytes S" inc R0" type >black ."  drop)" ; dis!
$09 :noname ( .inc)    ( a1 - a2)   1 bytes S" inc R1" type ; dis!
$0A :noname ( .inc)    ( a1 - a2)   1 bytes S" inc R2" type ; dis!
$0B :noname ( .inc)    ( a1 - a2)   1 bytes S" inc R3" type ; dis!
$0C :noname ( .inc)    ( a1 - a2)   1 bytes S" inc R4" type ; dis!
$0D :noname ( .inc)    ( a1 - a2)   1 bytes S" inc R5" type ; dis!
$0E :noname ( .inc)    ( a1 - a2)   1 bytes S" inc R6" type ; dis!
$0F :noname ( .inc)    ( a1 - a2)   1 bytes S" inc R7" type ; dis!

$10 :noname ( .jbc)    ( a1 - a2)   3 bytes S" jbc " type dup 2 - .bit
., dup .relative ; dis!
$11 :noname ( .acall)  ( a1 - a2)   2 bytes S" acall " type dup
.absolute ; dis!
$12 :noname ( .lcall)  ( a1 - a2)   3 bytes S" lcall " type dup .long ;
dis!
: show-2/  ( a - a)
	>black ."  2/" dup 3 - c@-t $a2 - if ." '" then ;
$13 :noname ( .rrc)    ( a1 - a2)   1 bytes S" rrc A" type show-2/ ; dis!
$14 :noname ( .dec)    ( a1 - a2)
   1 bytes S" dec A" type >black ."  1-" ; dis!
$15 :noname ( .dec)    ( a1 - a2)   2 bytes S" dec " type dup 1 -
.direct ; dis!
$16 :noname ( .dec)    ( a1 - a2)
   1 bytes S" dec @R0" type >black ."  u1-" ; dis!
$17 :noname ( .dec)    ( a1 - a2)   1 bytes S" dec @R1" type ; dis!
$18 :noname ( .dec)    ( a1 - a2)
   1 bytes S" dec R0" type >black ."  (dup" ; dis!
$19 :noname ( .dec)    ( a1 - a2)   1 bytes S" dec R1" type ; dis!
$1A :noname ( .dec)    ( a1 - a2)   1 bytes S" dec R2" type ; dis!
$1B :noname ( .dec)    ( a1 - a2)   1 bytes S" dec R3" type ; dis!
$1C :noname ( .dec)    ( a1 - a2)   1 bytes S" dec R4" type ; dis!
$1D :noname ( .dec)    ( a1 - a2)   1 bytes S" dec R5" type ; dis!
$1E :noname ( .dec)    ( a1 - a2)   1 bytes S" dec R6" type ; dis!
$1F :noname ( .dec)    ( a1 - a2)   1 bytes S" dec R7" type ; dis!

$20 :noname ( .jb)     ( a1 - a2)
   3 bytes S" jb " type dup 2 - .bit ., dup .relative
   >black ."  0=if." ; dis!
$21 :noname ( .ajmp)   ( a1 - a2)   2 bytes S" ajmp " type dup .absolute
; dis!
$22 :noname ( .ret)    ( a1 - a2)
   1 bytes S" ret" type >black ."  ;" ; dis!
$23 :noname ( .rl)     ( a1 - a2)   1 bytes S" rl A" type ; dis!
$24 :noname ( .add)    ( a1 - a2)
   2 bytes S" add A,#" type dup .# >black ."  #+" ; dis!
$25 :noname ( .add)    ( a1 - a2)   2 bytes S" add A," type dup 1 -
.direct ; dis!
$26 :noname ( .add)    ( a1 - a2)
   1 bytes S" add A,@R0" type >black ."  +" ; dis!
$27 :noname ( .add)    ( a1 - a2)   1 bytes S" add A,@R1" type ; dis!
$28 :noname ( .add)    ( a1 - a2)   1 bytes S" add A,R0" type ; dis!
$29 :noname ( .add)    ( a1 - a2)   1 bytes S" add A,R1" type ; dis!
$2A :noname ( .add)    ( a1 - a2)   1 bytes S" add A,R2" type ; dis!
$2B :noname ( .add)    ( a1 - a2)   1 bytes S" add A,R3" type ; dis!
$2C :noname ( .add)    ( a1 - a2)   1 bytes S" add A,R4" type ; dis!
$2D :noname ( .add)    ( a1 - a2)   1 bytes S" add A,R5" type ; dis!
$2E :noname ( .add)    ( a1 - a2)   1 bytes S" add A,R6" type ; dis!
$2F :noname ( .add)    ( a1 - a2)   1 bytes S" add A,R7" type ; dis!

$30 :noname ( .jnb)    ( a1 - a2)
   3 bytes S" jnb " type dup 2 - .bit ., dup .relative
   >black ."  if." ; dis!
$31 :noname ( .acall)  ( a1 - a2)   2 bytes S" acall " type dup
.absolute ; dis!
$32 :noname ( .reti)   ( a1 - a2)   1 bytes S" reti" type ; dis!
: show-2*  ( a - a)
	>black ."  2*" dup 2 - c@-t $c3 - if ." '" then ;
$33 :noname ( .rlc)    ( a1 - a2)   1 bytes S" rlc A" type show-2* ; dis!
$34 :noname ( .addc)   ( a1 - a2)
   2 bytes S" addc A,#" type dup .# >black ."  #+'" ; dis!
$35 :noname ( .addc)   ( a1 - a2)   2 bytes S" addc A," type dup 1 -
.direct ; dis!
$36 :noname ( .addc)   ( a1 - a2)
   1 bytes S" addc A,@R0" type >black ."  +'" ; dis!
$37 :noname ( .addc)   ( a1 - a2)   1 bytes S" addc A,@R1" type ; dis!
$38 :noname ( .addc)   ( a1 - a2)   1 bytes S" addc A,R0" type ; dis!
$39 :noname ( .addc)   ( a1 - a2)   1 bytes S" addc A,R1" type ; dis!
$3A :noname ( .addc)   ( a1 - a2)   1 bytes S" addc A,R2" type ; dis!
$3B :noname ( .addc)   ( a1 - a2)   1 bytes S" addc A,R3" type ; dis!
$3C :noname ( .addc)   ( a1 - a2)   1 bytes S" addc A,R4" type ; dis!
$3D :noname ( .addc)   ( a1 - a2)   1 bytes S" addc A,R5" type ; dis!
$3E :noname ( .addc)   ( a1 - a2)   1 bytes S" addc A,R6" type ; dis!
$3F :noname ( .addc)   ( a1 - a2)   1 bytes S" addc A,R7" type ; dis!

$40 :noname ( .jc)     ( a1 - a2)
   2 bytes S" jc " type dup .relative >black ."  0=if'" ; dis!
$41 :noname ( .ajmp)   ( a1 - a2)   2 bytes S" ajmp " type dup .absolute
; dis!
$42 :noname ( .orl)    ( a1 - a2)
   2 bytes S" orl " type dup 1 - .direct S" ,A" type
   >black ."  ior!" ; dis!
$43 :noname ( .orl)    ( a1 - a2)
   3 bytes S" orl " type dup 2 - .direct S" ,#" type dup .#
   >black ."  #ior!" ; dis!
$44 :noname ( .orl)    ( a1 - a2)
   2 bytes S" orl A,#" type dup .# >black ."  #ior" ; dis!
$45 :noname ( .orl)    ( a1 - a2)   2 bytes S" orl A," type dup 1 -
.direct ; dis!
$46 :noname ( .orl)    ( a1 - a2)
   1 bytes S" orl A,@R0" type >black ."  ior" ; dis!
$47 :noname ( .orl)    ( a1 - a2)   1 bytes S" orl A,@R1" type ; dis!
$48 :noname ( .orl)    ( a1 - a2)   1 bytes S" orl A,R0" type ; dis!
$49 :noname ( .orl)    ( a1 - a2)   1 bytes S" orl A,R1" type ; dis!
$4A :noname ( .orl)    ( a1 - a2)   1 bytes S" orl A,R2" type ; dis!
$4B :noname ( .orl)    ( a1 - a2)   1 bytes S" orl A,R3" type ; dis!
$4C :noname ( .orl)    ( a1 - a2)   1 bytes S" orl A,R4" type ; dis!
$4D :noname ( .orl)    ( a1 - a2)   1 bytes S" orl A,R5" type ; dis!
$4E :noname ( .orl)    ( a1 - a2)   1 bytes S" orl A,R6" type ; dis!
$4F :noname ( .orl)    ( a1 - a2)   1 bytes S" orl A,R7" type ; dis!

$50 :noname ( .jnc)    ( a1 - a2)
   2 bytes S" jnc " type dup .relative >black ."  if'" ; dis!
$51 :noname ( .acall)  ( a1 - a2)   2 bytes S" acall " type dup
.absolute ; dis!
$52 :noname ( .anl)    ( a1 - a2)
   2 bytes S" anl " type dup 1 - .direct S" ,A" type
   >black ."  and!" ; dis!
$53 :noname ( .anl)    ( a1 - a2)
   3 bytes S" anl " type dup 2 - .direct S" ,#" type dup .#
   >black ."  #and!" ; dis!
$54 :noname ( .anl)    ( a1 - a2)
   2 bytes S" anl A,#" type dup .# >black ."  #and" ; dis!
$55 :noname ( .anl)    ( a1 - a2)   2 bytes S" anl A," type dup 1 -
.direct ; dis!
$56 :noname ( .anl)    ( a1 - a2)
   1 bytes S" anl A,@R0" type >black ."  and" ; dis!
$57 :noname ( .anl)    ( a1 - a2)   1 bytes S" anl A,@R1" type ; dis!
$58 :noname ( .anl)    ( a1 - a2)   1 bytes S" anl A,R0" type ; dis!
$59 :noname ( .anl)    ( a1 - a2)   1 bytes S" anl A,R1" type ; dis!
$5A :noname ( .anl)    ( a1 - a2)   1 bytes S" anl A,R2" type ; dis!
$5B :noname ( .anl)    ( a1 - a2)   1 bytes S" anl A,R3" type ; dis!
$5C :noname ( .anl)    ( a1 - a2)   1 bytes S" anl A,R4" type ; dis!
$5D :noname ( .anl)    ( a1 - a2)   1 bytes S" anl A,R5" type ; dis!
$5E :noname ( .anl)    ( a1 - a2)   1 bytes S" anl A,R6" type ; dis!
$5F :noname ( .anl)    ( a1 - a2)   1 bytes S" anl A,R7" type ; dis!

$60 :noname ( .jz)     ( a1 - a2)
   2 bytes S" jz " type dup .relative >black ."  if" ;
dis!
$61 :noname ( .ajmp)   ( a1 - a2)   2 bytes S" ajmp " type dup .absolute
; dis!
$62 :noname ( .xrl)    ( a1 - a2)
   2 bytes S" xrl " type dup 1 - .direct S" ,A" type
   >black ."  xor!" ; dis!
$63 :noname ( .xrl)    ( a1 - a2)
   3 bytes S" xrl " type dup 2 - .direct S" ,#" type dup .#
   >black ."  #xor!" ; dis!
$64 :noname ( .xrl)    ( a1 - a2)
   2 bytes S" xrl A,#" type dup .# >black ."  #xor" ; dis!
$65 :noname ( .xrl)    ( a1 - a2)   2 bytes S" xrl A," type dup 1 -
.direct ; dis!
$66 :noname ( .xrl)    ( a1 - a2)
   1 bytes S" xrl A,@R0" type >black ."  xor" ; dis!
$67 :noname ( .xrl)    ( a1 - a2)   1 bytes S" xrl A,@R1" type ; dis!
$68 :noname ( .xrl)    ( a1 - a2)   1 bytes S" xrl A,R0" type ; dis!
$69 :noname ( .xrl)    ( a1 - a2)   1 bytes S" xrl A,R1" type ; dis!
$6A :noname ( .xrl)    ( a1 - a2)   1 bytes S" xrl A,R2" type ; dis!
$6B :noname ( .xrl)    ( a1 - a2)   1 bytes S" xrl A,R3" type ; dis!
$6C :noname ( .xrl)    ( a1 - a2)   1 bytes S" xrl A,R4" type ; dis!
$6D :noname ( .xrl)    ( a1 - a2)   1 bytes S" xrl A,R5" type ; dis!
$6E :noname ( .xrl)    ( a1 - a2)   1 bytes S" xrl A,R6" type ; dis!
$6F :noname ( .xrl)    ( a1 - a2)   1 bytes S" xrl A,R7" type ; dis!

$70 :noname ( .jnz)    ( a1 - a2)
   2 bytes S" jnz " type dup .relative >black ."  0=if" ; dis!
$71 :noname ( .acall)  ( a1 - a2)   2 bytes S" acall " type dup
.absolute  ; dis!
$72 :noname ( .orl)    ( a1 - a2)   2 bytes S" orl C," type dup 1 - .bit
; dis!
$73 :noname ( .jmp)    ( a1 - a2)   1 bytes S" jmp @A+DPTR" type ; dis!
$74 :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov A,#" type dup .# >black ."  #" ; dis!
: show-#!  >black ."  #!" ;
$75 :noname ( .mov)    ( a1 - a2)
   3 bytes S" mov " type dup 2 - .direct S" ,#" type dup .# show-#! ; dis!
$76 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov @R0,#" type dup .# ;
dis!
$77 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov @R1,#" type dup .# ;
dis!
$78 :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov R0,#" type dup .# show-#! ; dis!
$79 :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov R1,#" type dup .# >black ."  a!" ; dis!
$7A :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov R2,#" type dup .# show-#! ; dis!
$7B :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov R3,#" type dup .# show-#! ; dis!
$7C :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov R4,#" type dup .# show-#! ; dis!
$7D :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov R5,#" type dup .# show-#! ; dis!
$7E :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov R6,#" type dup .# show-#! ; dis!
$7F :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov R7,#" type dup .# show-#! ; dis!

$80 :noname ( .sjmp)   ( a1 - a2)
   2 bytes S" sjmp " type dup .relative >black ."  again" ; dis!
$81 :noname ( .ajmp)   ( a1 - a2)   2 bytes S" ajmp " type dup .absolute
; dis!
$82 :noname ( .anl)    ( a1 - a2)   2 bytes S" anl C," type dup 1 - .bit
; dis!
$83 :noname ( .movc)   ( a1 - a2)   1 bytes S" movc @A+PC" type ; dis!
$84 :noname ( .div)    ( a1 - a2)   1 bytes S" div AB" type ; dis!
$85 :noname ( .mov)    ( a1 - a2)   3 bytes S" mov " type dup 1 -
.direct ., dup 2 - .direct ; dis!
$86 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 -
.direct S" ,@R0" type ; dis!
$87 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 -
.direct S" ,@R1" type ; dis!
$88 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 -
.direct S" ,R0" type ; dis!
$89 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 -
.direct S" ,R1" type ; dis!
$8A :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 -
.direct S" ,R2" type ; dis!
$8B :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 -
.direct S" ,R3" type ; dis!
$8C :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 -
.direct S" ,R4" type ; dis!
$8D :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 -
.direct S" ,R5" type ; dis!
$8E :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 -
.direct S" ,R6" type ; dis!
$8F :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 -
.direct S" ,R7" type ; dis!

$90 :noname ( .mov)    ( a1 - a2)
   3 bytes S" mov DPTR,#" type dup 1 - .# dup .#
   >black ."  ##p!" ; dis!
$91 :noname ( .acall)  ( a1 - a2)   2 bytes S" acall " type dup
.absolute ; dis!
$92 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov " type dup 1 - .bit
S" ,C" type ; dis!
$93 :noname ( .movc)   ( a1 - a2)
   1 bytes S" movc A,@A+DPTR" type >black ."  @p" ; dis!
$94 :noname ( .subb)   ( a1 - a2)   2 bytes S" subb A,#" type dup .# ;
dis!
$95 :noname ( .subb)   ( a1 - a2)   2 bytes S" subb A," type dup 1 -
.direct ; dis!
$96 :noname ( .subb)   ( a1 - a2)   1 bytes S" subb A,@R0" type ; dis!
$97 :noname ( .subb)   ( a1 - a2)   1 bytes S" subb A,@R1" type ; dis!
$98 :noname ( .subb)   ( a1 - a2)   1 bytes S" subb A,R0" type ; dis!
$99 :noname ( .subb)   ( a1 - a2)   1 bytes S" subb A,R1" type ; dis!
$9A :noname ( .subb)   ( a1 - a2)   1 bytes S" subb A,R2" type ; dis!
$9B :noname ( .subb)   ( a1 - a2)   1 bytes S" subb A,R3" type ; dis!
$9C :noname ( .subb)   ( a1 - a2)   1 bytes S" subb A,R4" type ; dis!
$9D :noname ( .subb)   ( a1 - a2)   1 bytes S" subb A,R5" type ; dis!
$9E :noname ( .subb)   ( a1 - a2)   1 bytes S" subb A,R6" type ; dis!
$9F :noname ( .subb)   ( a1 - a2)   1 bytes S" subb A,R7" type ; dis!

$A0 :noname ( .orl)    ( a1 - a2)   2 bytes S" orl C,/" type dup 1 -
.bit ; dis!
$A1 :noname ( .ajmp)   ( a1 - a2)   2 bytes S" ajmp " type dup .absolute
; dis!
$A2 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov C," type dup 1 - .bit
; dis!
$A3 :noname ( .inc)    ( a1 - a2)   1 bytes S" inc DPTR" type ; dis!
$A4 :noname ( .mul)    ( a1 - a2)   1 bytes S" mul AB" type ; dis!
$A5 :noname ( .res)    ( a1 - a2)   1 bytes S" reserved" type ; dis!
$A6 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov @R0," type dup 1 -
.direct ; dis!
$A7 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov @R1," type dup 1 -
.direct ; dis!
$A8 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov R0," type dup 1 -
.direct ; dis!
$A9 :noname ( .mov)    ( a1 - a2)   2 bytes S" mov R1," type dup 1 -
.direct ; dis!
$AA :noname ( .mov)    ( a1 - a2)   2 bytes S" mov R2," type dup 1 -
.direct ; dis!
$AB :noname ( .mov)    ( a1 - a2)   2 bytes S" mov R3," type dup 1 -
.direct ; dis!
$AC :noname ( .mov)    ( a1 - a2)   2 bytes S" mov R4," type dup 1 -
.direct ; dis!
$AD :noname ( .mov)    ( a1 - a2)   2 bytes S" mov R5," type dup 1 -
.direct ; dis!
$AE :noname ( .mov)    ( a1 - a2)   2 bytes S" mov R6," type dup 1 -
.direct ; dis!
$AF :noname ( .mov)    ( a1 - a2)   2 bytes S" mov R7," type dup 1 -
.direct ; dis!

$B0 :noname ( .anl)    ( a1 - a2)   2 bytes S" anl C,/" type dup 1 -
.bit ; dis!
$B1 :noname ( .acall)  ( a1 - a2)   2 bytes S" acall " type dup
.absolute ; dis!
$B2 :noname ( .cpl)    ( a1 - a2)   2 bytes S" cpl " type dup 1 - .bit ;
dis!
$B3 :noname ( .cpl)    ( a1 - a2)   1 bytes S" cpl C" type ; dis!
$B4 :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne A,#" type dup 1 - .#
., dup .relative ; dis!
$B5 :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne A," type dup 2 -
.direct ., dup .relative ; dis!
$B6 :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne @R0,#" type dup 1 -
.# ., dup .relative ; dis!
$B7 :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne @R1,#" type dup 1 -
.# ., dup .relative ; dis!
$B8 :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne R0,#" type dup 1 -
.# ., dup .relative ; dis!
$B9 :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne R1,#" type dup 1 -
.# ., dup .relative ; dis!
$BA :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne R2,#" type dup 1 -
.# ., dup .relative ; dis!
$BB :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne R3,#" type dup 1 -
.# ., dup .relative ; dis!
$BC :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne R4,#" type dup 1 -
.# ., dup .relative ; dis!
$BD :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne R5,#" type dup 1 -
.# ., dup .relative ; dis!
$BE :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne R6,#" type dup 1 -
.# ., dup .relative ; dis!
$BF :noname ( .cjne)   ( a1 - a2)   3 bytes S" cjne R7,#" type dup 1 -
.# ., dup .relative ; dis!

$C0 :noname ( .push)   ( a1 - a2)
   2 bytes S" push " type dup 1 - .direct >black ."  push" ; dis!
$C1 :noname ( .ajmp)   ( a1 - a2)   2 bytes S" ajmp " type dup .absolute
; dis!
$C2 :noname ( .clr)    ( a1 - a2)   2 bytes S" clr " type dup 1 - .bit ;
dis!
$C3 :noname ( .clr)    ( a1 - a2)   1 bytes S" clr C" type ; dis!
$C4 :noname ( .swap)   ( a1 - a2)   1 bytes S" swap A" type ; dis!
$C5 :noname ( .xch)    ( a1 - a2)   2 bytes S" xch A," type dup 1 -
.direct ; dis!
$C6 :noname ( .xch)    ( a1 - a2)
   1 bytes S" xch A,@R0" type >black ."  swap" ; dis!
$C7 :noname ( .xch)    ( a1 - a2)   1 bytes S" xch A,@R1" type ; dis!
$C8 :noname ( .xch)    ( a1 - a2)   1 bytes S" xch A,R0" type ; dis!
$C9 :noname ( .xch)    ( a1 - a2)   1 bytes S" xch A,R1" type ; dis!
$CA :noname ( .xch)    ( a1 - a2)   1 bytes S" xch A,R2" type ; dis!
$CB :noname ( .xch)    ( a1 - a2)   1 bytes S" xch A,R3" type ; dis!
$CC :noname ( .xch)    ( a1 - a2)   1 bytes S" xch A,R4" type ; dis!
$CD :noname ( .xch)    ( a1 - a2)   1 bytes S" xch A,R5" type ; dis!
$CE :noname ( .xch)    ( a1 - a2)   1 bytes S" xch A,R6" type ; dis!
$CF :noname ( .xch)    ( a1 - a2)   1 bytes S" xch A,R7" type ; dis!

$D0 :noname ( .pop)    ( a1 - a2)
   2 bytes S" pop " type dup 1 - .direct >black ."  pop" ; dis!
$D1 :noname ( .acall)  ( a1 - a2)   2 bytes S" acall " type dup
.absolute ; dis!
$D2 :noname ( .setb)   ( a1 - a2)   2 bytes S" setb " type dup 1 - .bit
; dis!
$D3 :noname ( .setb)   ( a1 - a2)   1 bytes S" setb C" type ; dis!
$D4 :noname ( .da)     ( a1 - a2)   1 bytes S" da A" type ; dis!
: show-#next  >black ."  #next" ;
$D5 :noname ( .djnz)   ( a1 - a2)
   3 bytes S" djnz " type dup 2 - .direct ., dup .relative show-#next ; dis!
$D6 :noname ( .xchd)   ( a1 - a2)   1 bytes S" xchd A,@R0" type ; dis!
$D7 :noname ( .xchd)   ( a1 - a2)   1 bytes S" xchd A,@R1" type ; dis!
$D8 :noname ( .djnz)   ( a1 - a2)   2 bytes S" djnz R0," type dup
.relative show-#next ; dis!
$D9 :noname ( .djnz)   ( a1 - a2)   2 bytes S" djnz R1," type dup
.relative show-#next ; dis!
$DA :noname ( .djnz)   ( a1 - a2)   2 bytes S" djnz R2," type dup
.relative show-#next ; dis!
$DB :noname ( .djnz)   ( a1 - a2)   2 bytes S" djnz R3," type dup
.relative show-#next ; dis!
$DC :noname ( .djnz)   ( a1 - a2)   2 bytes S" djnz R4," type dup
.relative show-#next ; dis!
$DD :noname ( .djnz)   ( a1 - a2)   2 bytes S" djnz R5," type dup
.relative show-#next ; dis!
$DE :noname ( .djnz)   ( a1 - a2)   2 bytes S" djnz R6," type dup
.relative show-#next ; dis!
$DF :noname ( .djnz)   ( a1 - a2)   2 bytes S" djnz R7," type dup
.relative show-#next ; dis!

$E0 :noname ( .movx)   ( a1 - a2)   1 bytes S" movx A,@DPTR" type ; dis!
$E1 :noname ( .ajmp)   ( a1 - a2)   2 bytes S" ajmp " type dup .absolute ; dis!
$E2 :noname ( .movx)   ( a1 - a2)   1 bytes S" movx A,@R0" type ; dis!
$E3 :noname ( .movx)   ( a1 - a2)   1 bytes S" movx A,@R1" type ; dis!
$E4 :noname ( .clr)    ( a1 - a2)   1 bytes S" clr A" type ; dis!
$E5 :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov A," type dup 1 - .direct >black ."  #@" ; dis!
$E6 :noname ( .mov)    ( a1 - a2)
   1 bytes S" mov A,@R0" type >black ."  (drop" ; dis!
$E7 :noname ( .mov)    ( a1 - a2)
   1 bytes S" mov A,@R1" type >black ."  @" ; dis!
$E8 :noname ( .mov)    ( a1 - a2)   1 bytes S" mov A,R0" type ; dis!
$E9 :noname ( .mov)    ( a1 - a2)
   1 bytes S" mov A,R1" type >black ."  a" ; dis!
$EA :noname ( .mov)    ( a1 - a2)   1 bytes S" mov A,R2" type ; dis!
$EB :noname ( .mov)    ( a1 - a2)   1 bytes S" mov A,R3" type ; dis!
$EC :noname ( .mov)    ( a1 - a2)   1 bytes S" mov A,R4" type ; dis!
$ED :noname ( .mov)    ( a1 - a2)   1 bytes S" mov A,R5" type ; dis!
$EE :noname ( .mov)    ( a1 - a2)   1 bytes S" mov A,R6" type ; dis!
$EF :noname ( .mov)    ( a1 - a2)   1 bytes S" mov A,R7" type ; dis!

$F0 :noname ( .movx)   ( a1 - a2)   1 bytes S" movx @DPTR,A" type ; dis!
$F1 :noname ( .acall)  ( a1 - a2)   2 bytes S" acall " type dup
.absolute ; dis!
$F2 :noname ( .movx)   ( a1 - a2)   1 bytes S" movx @R0,A" type ; dis!
$F3 :noname ( .movx)   ( a1 - a2)   1 bytes S" movx @R1,A" type ; dis!
$F4 :noname ( .cpl)    ( a1 - a2)
   1 bytes S" cpl A" type >black ."  invert" ; dis!
$F5 :noname ( .mov)    ( a1 - a2)
   2 bytes S" mov " type dup 1 - .direct S" ,A" type show-#! ; dis!
$F6 :noname ( .mov)    ( a1 - a2)
   1 bytes S" mov @R0,A" type >black ."  dup)" ; dis!
$F7 :noname ( .mov)    ( a1 - a2)
   1 bytes S" mov @R1,A" type >black ."  !" ; dis!
$F8 :noname ( .mov)    ( a1 - a2)   1 bytes S" mov R0,A" type show-#! ; dis!
$F9 :noname ( .mov)    ( a1 - a2)
   1 bytes S" mov R1,A" type >black ."  a!" ; dis!
$FA :noname ( .mov)    ( a1 - a2)   1 bytes S" mov R2,A" type show-#! ; dis!
$FB :noname ( .mov)    ( a1 - a2)   1 bytes S" mov R3,A" type show-#! ; dis!
$FC :noname ( .mov)    ( a1 - a2)   1 bytes S" mov R4,A" type show-#! ; dis!
$FD :noname ( .mov)    ( a1 - a2)   1 bytes S" mov R5,A" type show-#! ; dis!
$FE :noname ( .mov)    ( a1 - a2)   1 bytes S" mov R6,A" type show-#! ; dis!
$FF :noname ( .mov)    ( a1 - a2)   1 bytes S" mov R7,A" type show-#! ; dis!

\ warning on

