\ flash_131201.fs -- Read/Write to flash memory -- 131201rjn
\ 
] ( target forth)  here  ( start marker)
\ 
\ -------------------[ save/restore from flash ]------------------------
\ 
\ start of config page can't be any larger (max = $1df0)
\ $1a00 constant config-block  ( config page is $1a00 to $1c00)
\ 
\ In erase mode, writing any byte to the block erases it.  Write $ff
\ -: erase-config    config-block ##p! $ff # +erase !x -write ;
\ 
\ fwrite only works if the block is first erased
-: !f  ( n -)   +write !x -write ;
:m fwrite  ( n -)  5 #for +write !x+ -write 5 #next m;
:m fwrite-dq    ( a -)    8 # @cells  8 # fwrite m; 
:m fwrite-quad  ( a -)    4 # @cells  4 # fwrite m;  \ lsb written first
:m !fd          ( a - )   2 # @cells  2 # fwrite m;
\ 
:m @f  ( - n)   |@p m;
:m fread  ( n - n ... n')   5 #for |@p+ 5 #next m;
:m fread-dq      ( a -)   8 # fread m; 
:m fread-quad    ( a -)   4 # fread m;
-: @fd            ( a -)   2 # fread ;  \ added 02Dec13 rjn
\  
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( flash_131201.fs         ) . .( bytes) [else] drop [then] 
]

\    
0 [if] \ ------------------------[ revisions ]---------------------------------
\   
Date	   By  Comment
=======	=== ===================================================================
140508   rjn add revision number, conditional compilation display.
02Dec13  rjn added !fd, @fd
01Dec13  rjn cloned from dcon
\ 
[then] \ ----------------------------------------------------------------------
