\ hextools_141010.fs -- convert, display, send hex -- 141010rjn
\
] here
\ 
0 [if] ----------------------[ hex digit conversion ]--------------------------

     Character Ranges --
		HEX DIGIT  	ASCII   0 ADJUSTED
		---------	-----   ----------
	   0-9         48-57    0-9
		none        58-64   10-16
		A-F         65-70   17-22
		none        71-96   23-48
		a-f         97-102  49-54
		none        >102    >54
		
[then] \ ----------------------------------------------------------------------
\ 
1 [if] \ ----------------[ convert two ASCII digits to hex ]-------------------
\ 
\ note: code saved, but not needed -- parameter is a single byte, not two chars
:m ?atof     ( n - n')    dup 23 # <if drop -7 # + -1 # ; then drop 0 # m;
:m gt9       ( n - n')    dup 17 # <if drop 0 # ; then drop ?atof m;
:m adjust    ( n - n')    -48 # + dup 10 # <if drop -1 # ; then drop gt9 m;
-: ?>uc       ( n - n')    dup 97 # <if drop ; then drop $DF # and ;

\ asc>hex? returns converted value and flag.  ff=ok, 0=bad digit
-: asc>hex?   ( n - n' ?)  dup 48 # <if drop 0 # ; then drop ?>uc adjust ; 
\ 
:m  (asc>hex?) \ process digit, exit with default and 0 flag on error 
   asc>hex? 0=if drop drop ( msd)  drop ( lsd) 0 # dup ; then drop m;
\                                     
-: (edigits)  ( asc-msd asc-lsd - n ?)   
   (asc>hex?) swap ( - lsd ascii-msd) (asc>hex?) 2* 2* 2* 2* ior  $ff # ;
\
-: $?  ( - n ?)  key dup emit key dup emit (edigits) ;
-: $  ( - n)  $? drop ;
: $$? ( - d ?)   $? $? push swap pop and  push swap pop ;
-: $$  ( - d)  $$? drop ;
      
dev? [if] \ ---------- development
   : $  ( - n)    $ ;
   : $$ ( - d)   $$ ;
   :m (drop  drop m;  \ 140722rjn
   : drop (drop ;     \ 140722rjn
[else]    \ ---------- turnkey

[then] \ ------------------------ 
\ 
[then] \ ----------------------------------------------------------------------
\ 
[ \ ===> gforth
\
\ ----- [ display, send hex digits ]
\ 
: (>dig)  ( n --)   48 + dup 57 > if 7 + then ; \ 0-15 to 0-F
: >dig  ( n --)   (>dig) emit ;
: >dig-s  ( n --)   (>dig) emit-s ;
: (h.)  ( n --)   $00ff and  16 /mod >dig >dig ;
: h.   (h.) space ;
: h.$  [char] $ emit h. ;
: h.-s  ( n --)  $00ff and 16 /mod >dig-s >dig-s ;
: (dh.)  dup  256 /  (h.) (h.) ;
: dh.  (dh.) space ;
: dh.$   [char] $ emit dh. ;
: (dh.$)  [char] $ emit  (dh.) ;
: dh.-s  ( n --)   dup 256 / h.-s h.-s  ;
] \ ===> myforth
\   
\ --- conditional compilation summary ---
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( hextools_141010.fs     ) . .( bytes) [else] drop [then]
]
\ 
\ 
0 [if] ------------------------[ revisions ]-----------------------------------
\ 
Date	   By  Comment
=======	=== ===================================================================
141010   rjn added error detection on hex entry, simplified code, released
141007   rjn corrected error in ?edigit2 -- error if msd is bad
140722   rjn added 'drop' to development definitions
140502   rjn changed name to add rev number (no code changes)
10Aug13  rjn changed for conditionaly compilation summary
23Jul13  rjn added hex digits in dbuf
22Jul13  rjn original version
\ 
[then] \ ----------------------------------------------------------------------


