\ job.fs -- RAFL radio frequency link -- 140929rjn
\ 
\ -----[ configure for 850 Dev ]
\ 
false   constant tethered
true    constant turnkeyed
true    constant standalone

true    constant cs?  \ produce compilation summary?
false    constant dev? \ development word, not for turnkey
\ 
\ -----[ interrupt vectors, chip constants ]
\ 
	$000  constant start        \ Reset vector.  Bootloader at $0000.
	$00B  constant TIM0         \ timer 0 interrupt
   $01B  constant TIM1         \ timer 1 overflow interrupt
   $023  constant RI           \ serial receive interrupt
   $02B  constant TIM2         \ timer 2 overflow interrupt
   $033  constant rom-start    \ start of code ($22b + $08)
   $1fff constant target-size  \ 8K flash

\ 
\ -----[ load MyForth system ] 
include loader_140220.fs
\ 
\ -----[ define SFRs, generate bootloader image ]
include sfr85x_140422.fs
\ 
\ (removed bootloader)
\ 
\ version string is placed here
rom-start [ 20 + ] org  \ leave room for version string
include serial_140722.fs      \ serial I/O, strings
here rom-start org  -: v  string " RAFL Ver. 141017" org  \ version string
\ 
include 25_delays_140502.fs   \ 25 MHz delays
include rafl_analog_setup.fs  \ analog primitives, initialization
include rafl_init.fs          \ chip initialization, I/O primitives
include rafl_utils.fs         \ misc. utils -- load before application
\ 
\ -----[ include interpreter(s) ]
\ 
tethered   [if] include tether_140502.fs [then]
\ 
standalone [if] 
   include standalone_140726.fs 
   dev? [if]
      include headers_140509.fs   \ list dictionary headers
   [then]
[then]
\ 
\ -----[ load the application ] 
\ 
\ rafl.txt                   \ text link to doc file
\ notes.txt                  \ misc. project-related notes
\ [ cr ]                     \ whitespace for compilation summary
include rafl_strings.fs      \ most strings defined here
include rafl_xram.fs         \ xram management (ram buffers, etc.)
include hextools_141010.fs   \ enter hex number, etc.
include rafl_timer0.fs       \ tick timer
\ include xors_140430.fs       \ xor macros (e.g., for case statements)
include xcells_140502.fs     \ access multiple direct cells
include flash_131201.fs      \ save/restore data from flash
include rafl_config.fs       \ configuration data for RAFL app.
include rafl_serial2rbuf.fs  \ capture serial output to xram
include multiply_140502.fs   \ multipication for analog scaling, temperature
include rafl_rdigits.fs      \ decimal digits for quad number, result in rbuf
include rafl_analog.fs       \ display analog input
\ include rafl_digital.fs      \ set, display DI, DO
include temperature.fs       \ RAFL 850 temperature readout
include 4432_spi.fs          \ 
include 4432_functions.fs
include rafl_exchange.fs     \ local/remote exchange
include rafl_autostart.fs    \ auto startup for remotes
include rafl_main.fs         \ go definition
\ include interactive.fs     \ Should come _after_ application for efficiency.
[ cr cr ] 
\ 
\ -----[ patch the reset vector ]
turnkeyed [if]	\ Turnkeyed with go.
	start interrupt -: cold /chip stacks go ;      \ patch reset to go 
[else]	        \ Testing with quit.
	start interrupt -: cold /chip stacks quit ;
[then]
\ 
\ -----[ select interactive or standalone ]
tethered [if]  \ interactive number entry
	:m # tnumber emit-s m;
	:m ## [ dup 8 rshift $ff and swap $ff and ] # # m;
[then]  
\
standalone [if]  \ standalone - patch dictionary pointer
\ Note: see config.fs -- headers are moved to the end of code by "headers"
        : r   cold  ;
        headers ] here [ dict org heads ##p! org ] 
        [ .( heads start at: ) heads .  .(  size: ) ] 
		  here [ heads - .  .(  bytes) ]
        dev? [if]
           here [ heads ] hstart org ## org   \ patch start of heads for .headers
        [then]
	here ( *) patch-cold org cold ( *) org  \ patch cold (after end of heads)
[then]
\
\ -----[ report build statistics ]
report
save
[ .( Host stack= ) .s
cr target-size ] here [ - .  .( bytes flash available) cr ]

\ 
0 [if] ---------------------[ Revision History ]-------------------------------
\ 
Date	  By  Description
======= === ===================================================================
140929  rjn removed bootloader.
\ 
[then] \ ----------------------------------------------------------------------


