\ multiply_140502.fs -- Multi-byte multiply by a constant -- 140502rjn
\ 
]  ( target forth)  here  ( * start)
\ 
\ 
0 [if] \ ----------------[ Russian Peasant Multipication ]---------------------
\
1. Multiplies a double quad number by a 4-byte constant using the Russian 
   Peasant algorithm (shifts and adds).
2. Uses the result register for the larger factor and 
   the scale register for the smaller factor.  The resulting product
   is in the prod register.  
3. Note: "dq" means "double quad", a 64-bit register.
\
[then] \ ----------------------------------------------------------------------
\ 
\ -----[ quad register, scale ]
\  
cpuHere constant scale  4 cpuALLOT  \ scale is MSB, scale 3 + is LSB

:m scale1  [ scale 1 + ] m;
:m scale2  [ scale 2 + ] m;
:m scale3  [ scale 3 + ] m;
\ 
-: 0scale  0 ##  0 ##  scale #  !quad ;
\ 
0 [if] \ ---------------------------------------------------------------------- 
-: scale2*'  \ multiply scale register by 2, keeping carry result
   clrc  scale3 #@ 2*' scale3 #!  scale2 #@ 2*' scale2 #!
         scale1 #@ 2*' scale1 #!  scale  #@ 2*' scale  #! ;
[then] \ ----------------------------------------------------------------------
\ 
\ -----[ prod -- double quad product register ]
\  
cpuHere constant prod 8 cpuALLOT  \ prod is MSB, prod 7 + is LSB
\ 
:m prod1  [ prod 1 + ] m;
:m prod2  [ prod 2 + ] m;
:m prod3  [ prod 3 + ] m;
:m prod4  [ prod 4 + ] m;
:m prod5  [ prod 5 + ] m;
:m prod6  [ prod 6 + ] m;
:m prod7  [ prod 7 + ] m;
\ 
-: 0prod  0 ##  0 ##  0 ##  0 ##  prod # !dq ;
\
\ load prod (test)
\ : lprod   $78 # $56 # $34 # $02 #  $67 # $45 # $23 # $01 #  !prod ;  
\ 
\ -----[ result -- double quad factor "a" register ]
\ 
\ multiply result ends up here
\ 
cpuHere constant result  8 cpuALLOT  \ result is MSB, result 7 + is LSB
\ 
:m result1  [ result 1 + ] m;
:m result2  [ result 2 + ] m;
:m result3  [ result 3 + ] m;
:m result4  [ result 4 + ] m;
:m result5  [ result 5 + ] m;
:m result6  [ result 6 + ] m;
:m result7  [ result 7 + ] m;
\ 
-: 0result  0 ##  0 ##  0 ##  0 ##  result #  !dq ;
-: ff>result  $ffff ##  $ffff ##  $ffff ##  $ffff ##  result # !dq ;
:m prod>result  prod # 8 # @cells<  result #  !dq m; 
:m result>prod  result # 8 # @cells<  prod #  !dq m;  

\
\ : lresult   $78 # $56 # $34 # $02 #  $67 # $45 # $23 # $01 #  !result ; \ test 
\
-: result2*'  \ multiply contents of result register by 2, keep carry result
   clrc   result7 #@  2*' result7 #!  result6 #@  2*' result6 #!  
          result5 #@  2*' result5 #!  result4 #@  2*' result4 #!  
          result3 #@  2*' result3 #!  result2 #@  2*' result2 #!  
          result1 #@  2*' result1 #!  result  #@  2*' result  #! ;
\ 
\ -----[ Add, Subtract result to/from prod ]
\ 
:m |prod+result
	[ t push  clrc
      prod7 t mov  result7 addc  t prod7 mov
      prod6 t mov  result6 addc  t prod6 mov
      prod5 t mov  result5 addc  t prod5 mov
      prod4 t mov  result4 addc  t prod4 mov
      prod3 t mov  result3 addc  t prod3 mov
      prod2 t mov  result2 addc  t prod2 mov
      prod1 t mov  result1 addc  t prod1 mov
      prod  t mov  result  addc  t prod  mov
   t pop ]
m;
\
-: prod+result  |prod+result ;  \ results in prod
\ 
:m |result+prod
	[ t push  clrc
         result7 t mov  prod7 addc  t result7 mov
         result6 t mov  prod6 addc  t result6 mov
        	result5 t mov  prod5 addc  t result5 mov
         result4 t mov  prod4 addc  t result4 mov
        	result3 t mov  prod3 addc  t result3 mov
         result2 t mov  prod2 addc  t result2 mov
         result1 t mov  prod1 addc  t result1 mov
        	result  t mov  prod  addc  t result  mov
          t pop ]
m;
\ 
-: result+prod  |result+prod ;  \ results in result
\ 
1 [if] \ ----------------------------------------------------------------------
\ 
:m |prod-result
	[ t push  clrc
      prod7 t mov  result7 subb  t prod7 mov
      prod6 t mov  result6 subb  t prod6 mov
      prod5 t mov  result5 subb  t prod5 mov
      prod4 t mov  result4 subb  t prod4 mov
      prod3 t mov  result3 subb  t prod3 mov
      prod2 t mov  result2 subb  t prod2 mov
      prod1 t mov  result1 subb  t prod1 mov
      prod  t mov  result  subb  t prod  mov
   t pop ]
m;
\
\ : prod-result  |prod-result ;  \ results in prod

:m |result-prod
	[ t push  clrc
      result7 t mov  prod7 subb  t result7 mov
      result6 t mov  prod6 subb  t result6 mov
      result5 t mov  prod5 subb  t result5 mov
      result4 t mov  prod4 subb  t result4 mov
      result3 t mov  prod3 subb  t result3 mov
      result2 t mov  prod2 subb  t result2 mov
      result1 t mov  prod1 subb  t result1 mov
      result  t mov  prod  subb  t result  mov
   t pop ]
m;
\
-: result-prod  |result-prod ;  \ results in result
\ 
[then] \ ----------------------------------------------------------------------
\ 
\ : cs$  string " cs! "  \ debug
\ 
-: scale2/' \ divide scale register by 2, accumulate remainder on carry result
   clrc  scale  #@  2/'  scale  #!  scale1 #@  2/' scale1 #!
         scale2 #@  2/'  scale2 #!  scale3 #@  2/' scale3 #!
   if' prod+result ( can't be a macro!) ( cr cs$) ; then ;

-: scale2*' \ multiply scale register by 2
   clrc  scale3  #@  2*'  scale3  #!  scale2 #@  2*' scale2 #!
         scale1  #@  2*'  scale1  #!  scale  #@  2*' scale  #! ;
\ 
\ -----[ load scale ]
\ 
-: (msteps)  ( - n)  \ calculate multiply steps by looking for the last "1" 
   32 #  32 #  4 #for scale2*' if' ; then -1 # + 4 #next ;

\ assumes scale loaded, calculates number of multiply steps, preserves scale
-: msteps  ( - n)  scale # 4 # @cells<  (msteps)  push scale # 4 # !cells pop ;

\ note: 31 bytes, this is the last step: remainders are accumulated X 2
-: prod/2'  \ divide contents of prod register by 2, keep carry info   
   clrc   prod  #@  2/' prod  #!  prod1 #@  2/'  prod1 #!
          prod2 #@  2/' prod2 #!  prod3 #@  2/'  prod3 #!
          prod4 #@  2/' prod4 #!  prod5 #@  2/'  prod5 #!
          prod6 #@  2/' prod6 #!  prod7 #@  2/'  prod7 #! ;

\ for results accumulated in result (e.g., multiple temperature readings)
-: result/2'  \ divide contents of result register by 2, keep carry info   
   clrc   result  #@  2/' result  #!  result1 #@  2/'  result1 #!
          result2 #@  2/' result2 #!  result3 #@  2/'  result3 #!
          result4 #@  2/' result4 #!  result5 #@  2/'  result5 #!
          result6 #@  2/' result6 #!  result7 #@  2/'  result7 #! ;
          
\ 
1 [if] \ ---------------------------- prod ------------------------------------
\
-: multiply  \ multiply result by scale, results in prod   
   0prod msteps 4 #for result2*' scale2/' 4 #next  prod/2'  ;
\ 
\ load factors in scale and result, results in result
:m 10>scale  0scale $0a # scale3 #! m;
-: result*10  10>scale  multiply  prod>result ;
\
[then] \ ----------------------------------------------------------------------
\ 
0 [if] \ ----------------------------- test -----------------------------------
\
-: s$  string " start: "
-: f$  string " finish: "
-: .minfo   .scale .result .prod ; \ display mult. regs
-: d$  string " -----------" 
\ 
\ load scale and result first
-: multiply  \ multiply scale and result, results in prod 
   0prod cr s$ .minfo
   msteps  4 #for cr d$  result2*' scale2/'  .minfo  4 #next 
   prod/2' cr cr f$ .minfo ;
\
[then] \ ----------------------------------------------------------------------
\
0 [if] \ -------------------------- test --------------------------------------
\ 
\ Example for 50 MHz frequency, 125 MHz xtal, scale scaled by 2**22:
\ ($2FAF080)($89705F4)=$199999995FBA00
\ dividing by 2**22=$66666665=1,717,986,917 (vs. 1,717,986,918)
\
[then] \ ---------------------------------------------------------------------- 
\
\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( multiply_140502.fs     ) . .( bytes) [else] drop [then]
]
\ 
0 [if] \ ------------------------[ revisions ]---------------------------------
\ 
Date	   By  Comment
=======	=== ===================================================================
140502   rjn added rev number and put in library
04Sep12  rjn eliminated defs to reduce code size
30Aug12  rjn changed quadb name to scale (looks better on report)
14Aug12  rjn scaling by 2**22 yields a result within 1 Hertz
13Aug12  rjn now works for a double quad product
11Aug12  rjn initial version cloned from Oudin multiply
\ 
[then] \ ----------------------------------------------------------------------
