\ rafl_analogs.fs -- ADC standalone commands -- 140809rjn
\ 
] here

-: (acc)  ( d --)   prod6 #!  prod7 #!  result+prod ;

-: @dresult  ( - d)   result7 #@  result6 #@ ;
-: !dresult  ( d -)   result6 #!  result7 #! ;

-: (ar)   analog-defaults  enable-adc ;
-: ar  ( -- d)   (ar)  aread  ;  \ read currently-selected ADC channel

-: (.d&h)   ( d --)   2dup  ud.  dh. ;
-: .d&h     ( d --)   (.d&h) space ;
\ -: .2dar  ar .d&h ;
-: .dar  ar dh. space ;  \ now return only hex -- 140622rjn
-: .dresult  @dresult  .d&h ;
\ -: .dresult  @dresult  dh. space ;
\ 
\ -----[ analog counts ]
\ : acnt   p17-select  .dar ;
\ 
\ -----[ multiple raw readings ]
\ 
\ -: (.dar)  32 # 4 #for cr ar .d&h  4 #next ;
\ : araw  p17-select (.dar) ;
\ 
1 [if] \ -------------------[ averaged readings ]------------------------------
\ 
-: gn   \ avg of currently selected analog port/pin, avg. in result
   0prod  0result  \ zero out prod and freq double quad registers
   32 # 4 #for ar (acc) 4 #next          \ accumulate multiple readings in prod
   0 # prod6 #!  8 # prod7 #!  result+prod  \ round by 0.5, put in result
\   result>prod                              \ save accumulated in prod
   5 # 4 #for result/2' 4 #next ;           \ divide accumulated in result by 32

\ : total  prod7 #@  prod6 #@  .d&h ;
\ 
\ -----[ avg of multiple readings on specified channels ]------
\
\ -: (gn)   gn .dresult ;

\ : avg  p17-select (gn) ;

\ 
[then] \ ----------------------------------------------------------------------
\ 
1 [if] \ --------------------[ analog scaling ]--------------------------------
\ 
\ cpuHERE constant ascale 2 cpuALLOT  \ A/D scaling factor in mV/count

\ -: ad  [ ascale 1+ ] #@  ascale #@  ( .d&h) dh. ;  \ 140614rjn
\ 
-: doscale  \ scale avg. voltage in result
\ 3.3/$2000 = 0.00040283203125, use 40283 = $9d5b
\ round up from 40280 to 40300 = $9d6c
\ 
\ $9d5b gives an error of -12.77 mv error (max) at 2.75 Volts
\   0scale  $9d # scale2 #!  $5b # scale3 #!  multiply ; \ about 4 mv low
\ 
\ this corresponds to 3.3089/$2000 -- this was used for the error plots
\   0scale  $9d # scale2 #!  $c8 # scale3 #!  multiply ;
\ 
\ 402832=$62590 -- using extra digit doesn't help much
\   0scale  $06 # scale1 #! $25 # scale2 #!  $90 # scale3 #!  multiply ;
\ 
\ used $9e00 for DACS V2 Error plot dated 140501
\    0scale  $9e # scale2 #!  $00 # scale3 #!  multiply ; \ about 1 mv high
\ 
\ Note that the voltage reference can range from 1.62 to 1.68 Volts
\ The development DAC appears to have a Vref of 1.6551 Volts  
\ Thus, 3.3102/$2000 = 0.000404077 => use multiplier of 40408
\     0scale  $9d # scale2 #!  $d8 # scale3 #!  multiply ; \ 40408
     0scale ascale #@ scale2 #!  [ ascale 1+ ] #@ scale3 #!  multiply ;

\ -: vn  gn doscale  2dp  7 # ?.qdigits ;

-: (vn-)  \ compensates a bit for zero error
   gn  result7 #@  result6 #@  4 ## dnegate d+  \ subtract 4 from average
\ note: considered rounding at the tenth millivolt position but since
\       a count is 0.4 millivolt, adding one would almost be as good as
\       adding 0.5 millivolt.  But, that would mean just subtracting 3
\       instead of 4, so ...
   -if drop drop doscale ; then  result6 #!  result7 #! doscale ;

0 [if] \ --------------[ voltage resolution ]----------------------------------
\ 
cpuHERE constant vdigits 1 cpuALLOT  \ true= 5 digits, false= 3 digits

-: hire$  string " high"
-: lore$  string " low "
-: high  $ff # vdigits #! ;
-: low     0 # vdigits #! ;
-: res  vdigits #@ 0=if drop lore$ ; then drop hire$ ;
-: /vdigits  low ;

\ -: vn-  (vn-)  2dp  7 # ?.qdigits ;
-: vn-  (vn-)  
   2dp  vdigits #@ 0=if drop 5 # ?.rdigits ; then drop 7 # ?.rdigits ;
-: vn  vn- space ;
\ 
[then] \ ----------------------------------------------------------------------
\ 
-: vn  (vn-)  2dp  5 # ?.rdigits ;
\ -: 'vin  string "  |vin "
-: vin>rbuf  p17-select  vn  ;  \ outputs to current rbuf position
\ 
[then] \ ----------------------------------------------------------------------
\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( rafl_analog.fs         ) . .( bytes) [else] drop [then] 
]
\ 
\ 
0 [if] ------------------------[ revisions ]-----------------------------------
\ 
Date	   By  Comment
=======	=== ===================================================================
140809   rjn cloned from analogs.fs in DACS application
\ 
[then] \ ----------------------------------------------------------------------


