\ rafl_analog_setup.fs -- analog setup -- 140809rjn
\ 
] here
\ 
\ -----[ read analog ]
\ 
-: (aread)   \ read currently selected channel   
   [ 4 .ADC0CN0 set ] ( start) 
   begin  5 .ADC0CN0 until.  \ wait for completion
   [ 5 .ADC0CN0 clr ]   ;    \ clear completion bit
   
-: aread   (aread)  ADC0L #@  ADC0H #@  ;  \ read value from result register

\ 
\ ADC0CF
\ 
\ $28 # ADC0CF  #!     
\ ADSC(7:3)=00101, ADSC clock divider (~4 MHz)
\ AD8BE(2)=0, 10 or 12 bit operation
\ ADTM(1)=0, normal track mode
\ ADGN(0)=0, PGA gain is 0.5
:m 4mHz-SAR    $28  # ADC0CF #!   m;
:m full-gain   $01  # ADC0CF ior! m;
:m half-gain   $01 ~# ADC0CF and! m;
\ 
\ ADC0CN0 (bit addressable)
\ 
\   $80 # ADC0CN0 #!     \ ADEN(7)=1, enable ADC0
                        \ ADBMEN(6)=0, burst mode disabled
                        \ ADINT(5)=0, set by H/W = end of conv., reset with S/W
                        \ ADBUSY(4)=0, write 1 to start conversion
                        \ ADWINT(3)=0, window compare interrupt flag
                        \ ADCM(2:0)=000, conv. init on write to ADBUSY
:m enable-adc      [ 7 .ADC0CN0 set ] m;
:m disable-adc     [ 7 .ADC0CN0 clr ] m;

:m burst-enabled   [ 6 .ADC0CN0 set ] m;
:m burst-disabled  [ 6 .ADC0CN0 clr ] m;
\ 
\ ADC0CN1
\ 
\ ADCMBE(0)=1, enable common mode buffer
:m enable-cm-buffer   $01 # ADC0CN1 #! m;
:m disable-cm-buffer  $00 # ADC0CN1 #! m;
\ 
\ REF0CN -- reference source, ground reference, enable/disable temp. sense
\ 
\ IREFLVL(7)=0, 1.65 internal reference ($18 is default)
\ bit 6 is reserved, must write 0
\ GNDSL(5)=0, ground reference is the GND pin
\ REFSL(4:3)=11, voltage reference is internal reference
\ TEMPE(2)=0, temperature sensor disabled
\ bits 1:0 are reserved, must write 0
:m ref=165        $00  # REF0CN ior! m;
:m ref=240        $80  # REF0CN ior! m;
:m tsense-on      $04  # REF0CN ior! m;
:m tsense-off     $04 ~# REF0CN and! m;

\ 
\ ADC0MX -- selects mux channel 
\ 
:m tsense-select  $10  # ADC0MX #!   m;  \ select temperature sensor
:m p10-select     $08  # ADC0MX #!   m;  \ select P1.0
:m p11-select     $09  # ADC0MX #!   m;  \ select P1.1
:m p12-select     $0a  # ADC0MX #!   m;  \ select P1.2
:m p13-select     $0b  # ADC0MX #!   m;  \ select P1.3
:m p14-select     $0c  # ADC0MX #!   m;  \ select P1.1
:m p15-select     $0d  # ADC0MX #!   m;  \ select P1.2
:m p16-select     $0e  # ADC0MX #!   m;  \ select P1.3
:m p17-select     $0f  # ADC0MX #!   m;  \ select P1.7

\ 
\ ADC0AC
\ 
\ AD12BE(7)=0, 12-bit mode disabled
\ ADAE(6)=0, ADC0H:ADC0L contain results, burst off
\ ADSJST(5:3)=000, right justified, no shifts
\ ADRPT(2:0)=000, perform and accumulate 1 conversion
:m 12-bit      $81  # ADC0AC #! m;  \ repeat=1, shift=0, 12 bits
:m 13-bit      $9d  # ADC0AC #! m;  \ repeat=64, shift=3, 13 bits      
:m 10-bit      $00  # ADC0AC #! m;  \ 12-bit disabled

-: analog-defaults   
   half-gain  burst-enabled  enable-cm-buffer 13-bit  ref=165 ;

-: /analog
\ 
\ ----- analog configuration & initialization 
\ 
\   enable-adc           \ ADC0CN0
   4mHz-SAR              \ ADC0CF
   analog-defaults
   $c0 # ADC0PWR #!     \ ADBIAS(7:6)=11, select bias current mode 3
                        \ ADMXLP(5)=0, low power mode disabled
                        \ ADLPM(4)=0, disable low power mode
                        \ ADPWR(3:0)=0000, burst mode power up time
   $80 # ADC0TK  #!     \ AD12SM(7)=1, one sample per 12-bit conversion (???????) 
                        \ bit 6 is reserved, must write 0
                        \ ADTK(5:0)=00000  
\   p12-select           \ ADC0MX -- select P1.2 AIN
;
\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( rafl_analog_setup.fs    ) . .( bytes) [else] drop [then] 
]
\ 
\ 
0 [if] ------------------------[ revisions ]-----------------------------------
\ 
Date	   By  Comment
=======	=== ===================================================================
140809   rjn cloned from dacs_analog_setup.fs
\ 
[then] \ ----------------------------------------------------------------------


