\ rafl_config.fs -- save/restore configuration settings  -- 141009rjn
\ 
] ( target forth)  here  ( start marker)
\ 
\ 
1 [if] \ ------------------[ configuration block ]-----------------------------
\ 
$1e00 constant config-block  ( config page is 512 bytes from $1e00 to $1fff)
\ 
\ In erase mode, writing any byte to the block erases it.  Write $ff
-: (erase-config)    config-block ##p! $ff # +erase !x -write ;
\ SL says that flash lasts longer with two erases before a write
-: erase-config  (erase-config) (erase-config) ;
\ 
\ note: -touched? is set to zero when  flash is saved -- it is an init flag
config-block constant -touched?  \ $ff for no flash write
-: f-touched  -touched? ##p!  0 # !f ;
\ 
[then] \ ----------------------------------------------------------------------
\
1 [if] \ ---------------------[ Custom Settings ]------------------------------
\ 
\ Note: doubles are stored lsb first
\ 
$000B constant serial_number
\ 
[ serial_number $0001 = ] [if]                  \ 141015rjn
   here constant snumber         $01 , $00 ,
   here constant ascale-default  $2f , $9d , 
   here constant cz-default      $8f , $07 ,
[then]
[ serial_number $0002 = ] [if]
   here constant snumber         $02 , $00 ,
   here constant ascale-default  $f5 , $9d , 
   here constant cz-default      $7e , $06 ,
[then]
[ serial_number $000B = ] [if]                  \ 141017rjn
   here constant snumber         $0b , $00 ,
   here constant ascale-default  $80 , $9d , 
   here constant cz-default      $04 , $07 ,
[then]

-: .ser  snumber  ##p!  @fd  'ser (dh.) ;

[then] \ ----------------------------------------------------------------------
\ 
1 [if] \ ------------------[ Celsius Zero Crossing ]---------------------------
\ 
cpuHERE constant cz0 2 cpuALLOT  \ cz0 is msb, see temperature.fs
\ 
-: @cz0  ( - d)   cz0 # @rd< ;
-: .cz  'cz=  cz0 # @rd<  (dh.) ;
\ 
[ config-block 1+ ] constant #f-cz
-: cz>flash   #f-cz ##p!  cz0 #  !fd ;

:m !cz  ( a -)   ##p!  @fd  cz0 # !rd m;
-: /cz<flash  #f-cz ##p!  @fd  cz0 # !rd ;  \ init Celsius zero xing from flash
\ 
\ -: cz-def ; \ label for looking at defaults
\ 
-: /cz<default  cz-default  !cz ; \ init cz from default
\ 
[then] \ ----------------------------------------------------------------------
\  
1 [if] \ -----------------------[ A/D Scaling ]--------------------------------
\ 
cpuHERE constant ascale 2 cpuALLOT  \ A/D scaling, mV/cnt, ascale is msb
\  
[ config-block 3 + ] constant #f-ascale
-: ascale>flash   #f-ascale ##p!  ascale #  !fd ;
-: /ascale<flash  #f-ascale ##p!  @fd  ascale # !rd ;  \ init scaling factor
\ 
\ ----- ascale default (not changed after calibration)
\ -: ascale-def ; \ label for looking at defaults 

-: /ascale<default  ascale-default  ##p!  @fd  ascale # !rd ; \ init from default
\
-: @ascale  ( - d)  [ ascale 1+ ] #@  ascale #@ ; 
\ -: .as    @ascale  'as=  (dh.) ;
-: (as=)  $$? if drop ascale # !rd ; then drop drop drop ;
\ 
[then] \ ---------------------------------------------------------------------- 
\   
1 [if] \ -------------------[ terminator byte ]--------------------------------
\ 
\ 1. It is a user-settable variable
\ 2. It is used to terminate an entry in terminal mode
\ 
cpuHere constant ~tb 1 cpuAllot  \ terminator byte
$0d constant tb#

:m @tb  ( - n)   ~tb #@ m;
:m !tb  ( n -)   ~tb #! m;
:m /tb  tb# # !tb m;  \ normally set at startup from default or config block

\ -: 'tb=  string " tb="
-: .tb  @tb  'tb= (h.) ;    \ show terminator byte
-: (tb=)   $? if drop !tb ; then drop drop ;
: tb=  (tb=) space .tb 'bar ;    \ enter terminator byte 
\ 
[ config-block 6 + ] constant #f-tb
-: tb>flash   #f-tb ##p!  @tb  !f  ;
-: /tb<flash  #f-tb ##p!  @f   !tb ;  \ init terminator byte from flash
\ 
\ ----- tb default
\ -: tb-def ; \ label for looking at default 
\ 
here constant tb-default  tb# ,  \ carriage return
\ 
-: /tb<default  tb-default ##p! @f !tb ; \ init from default
\ 
[then] \ ----------------------------------------------------------------------  
\ 
1 [if] \ ----------------------[ escape byte ]---------------------------------
\ 
\ 1. If the escape byte is received in the input stream the transmission is
\     aborted and the master goes into command mode.
\ 2. The escape byte is a user-settable variable
\ 3. For an escaped entry, the escape character is written, terminating the
\    data entry.  For an escaped entry, the command byte is still written 
\    but not needed.  Escape to the command mode is performed by examinging
\    second to last byte (the one preceding the command byte) to see if
\    is the escape character. 
\ 
cpuHere constant ~eb 1 cpuAllot  \ escape byte
$1b constant eb#

:m @eb  ( - n)   ~eb #@ m;
:m !eb  ( n -)   ~eb #! m;
:m /eb  eb# # !eb m;  \ normally set at startup from default or config block

\ -: 'eb=  string " |eb= "
-: .eb  @eb 'eb=  (h.) ;     \ show escape byte
-: (eb=)   $? if drop !eb ; then drop drop ;
: eb=  (eb=) space .eb 'bar ;  \ enter escape byte 

[ config-block 7 + ] constant #f-eb
-: eb>flash   #f-eb ##p!  @eb  !f  ;
-: /eb<flash  #f-eb ##p!  @f   !eb ;  \ init terminator byte from flash
\ 
\ ----- eb default
\ -: eb-def ; \ label for looking at default 
\ 
here constant eb-default  eb# ,  \ Esc
\ 
-: /eb<default  eb-default ##p! @f !eb ; \ init from default
\ 
[then] \ ----------------------------------------------------------------------
\ 
1 [if] \ ---------------------[ master/remote ]--------------------------------
\ 
\ 1. The master/remote flag controls whether or not the unit boots up as
\    a master or remote after an autostart.
\ 2. If, during autostart, the user presses any key, then autostart is 
\     terminated and options such as master/remote can be changed.
\ 3. "master" and "remote" set the values in configuration flash for
\     autostart into one of the two modes.
\ 
cpuHere constant ~mr 1 cpuAllot  \ master/remote flag  true=remote
$ff constant mr#

:m @mr  ( - n)   ~mr #@ m;
:m !mr  ( n -)   ~mr #! m;
:m /mr  mr# # !mr m;

\ -: 'mas  string " |mas "
-: .mr  'mas  @mr invert (h.) ;

-: (master)  0 #  !mr ;
: master  (master)  .mr 'bar ;
: remote       /mr  .mr  'bar ;

[ config-block 8 + ] constant #f-mr
\ 
-: mr>flash   #f-mr ##p!  @mr  !f  ;
-: /mr<flash  #f-mr ##p!  @f   !mr ;  \ init terminator byte from flash
\ 
\ ----- mr default
\ -: mr-def ; \ label for looking at default 
\ 
here constant mr-default  mr# ,  \ remote
\ 
-: /mr<default  mr-default ##p! @f !mr ; \ init from default
\ 
[then] \ ----------------------------------------------------------------------
\ 
1 [if] \ ---------------------[ message length ]-------------------------------
\ 
\ 1. The message length byte sets the maximum number of chars allowed on input.
\ 2. It is a user-settable variable that can be saved to flash.
\ 
cpuHere constant ~ml 1 cpuAllot  \ max message length

:m @ml  ( - n)   ~ml #@  m;
\ :m !ml  ( n -)  1 # max  $3f # and  ~ml #! m;
-: !ml  ( n -)   dup $40 # <if drop ~ml #! ; then drop drop ;

-: .ml  @ml 'ml= (h.) ;   \ show message length
-: (ml=)  $? if drop !ml ; then drop drop ;
: ml=  (ml=) space .ml 'bar ;  \ set and show msg length
\ 
[ config-block 9 + ] constant #f-ml
\ 
-: ml>flash   #f-ml ##p!  @ml  !f  ;
-: /ml<flash  #f-ml ##p!  @f   !ml ;  \ init terminator byte from flash
\ 
\ ----- ml default
\ -: ml-def ; \ label for looking at default 
\ 
here constant ml-default  $3f ,
\ 
-: /ml<default  ml-default ##p! @f !ml ; \ init ml from default
\ 
[then] \ ----------------------------------------------------------------------
\
1 [if] \ -------------[ command/address (single byte) ]------------------------
\ 
cpuHere constant ~cad 1 cpuAllot  \ single byte combined command/address
\ 
\ Notes:
\ 1. Upper 3 bits are command
\ 2. Lower 5 bits are address
\ 3. Address of master is always $1f
\ 
-: @cad  ( - n)   ~cad #@ ;
-: !cad  ( n -)   ~cad #! ;

-: (!adr)  ( n -)   ( $1f # and)   @cad $e0 # and  ior  ~cad #! ;
-: !adr  ( n -)  dup $20 # <if drop (!adr) ; then drop drop ;

-: !cmd  ( n -)   $07 # and  [ clrc rrc rrc rrc rrc ]
   @cad $1f # and  ior  ~cad #! ;

-: mask_adr  ( n - n')   $1f # and ;
-: @adr  ( - n)   @cad mask_adr ;
-: >cmd  ( n - n')   $e0 # and [ clrc rlc rlc rlc rlc ] ;  
-: @cmd  ( - n)   @cad >cmd ;

-: .cmd  @cmd  'cmd  (h.) ;
-: (.ad=)   'ad= (h.) ;
-: .ad=  @adr  (.ad=) ;

\ -: 'ad=  string "  |ad= "
-: (ad=)   $? if drop !adr ; then drop drop ;
: ad=  (ad=) space .ad= 'bar ;  \ user command to set adr

$00 constant #lm    \ loopback command
$01 constant #tm    \ terminal command
$02 constant #stat  \ status command
$03 constant #dm    \ data command
$04 constant #bm    \ broadcast command (same as terminal, no return msg)
$05 constant #last  \ one shot cmd to get results of last bcast msg

:m lm#     #lm    # m;
:m tm#     #tm    # m;
:m stat#   #stat  # m;
:m dm#     #dm    # m;
:m bm#     #bm    # m;
:m last#   #last  # m;

-: last  last# !cmd ;
-: (?m)  \ return current mode
   @cmd 
\ ----- loopback -----
   lm# xor 0=if drop 'lm= lm# ; then  lm# xor
\ ----- terminal -----
   tm# xor 0=if drop 'tm= tm# ; then  tm# xor
\ ----- broadcast message -----
   bm# xor 0=if drop 'bm= bm# ; then  bm# xor
\ ----- data mode -----   
   dm# xor 0=if drop 'dm= dm# ; then  dm# xor
\ ----- unknown mode -----   
   '??? ( shouldn't happen) ; 

: ?m   (?m)  h| ;

: lm   lm# !cmd  ?m ;
: tm   tm# !cmd  ?m ;
-: status    stat# dup !cmd !status ;  \ also flag status post-processing
: dm   dm# !cmd  ?m ;
: bm   bm# !cmd  ?m ;

[ config-block 10 + ] constant #f-cad
\
-: cad>flash   #f-cad ##p!  @cad  !f ;  \ set cmd/adr in flash (erase first)
-: /cad<flash  #f-cad ##p!  @f  !cad ;  \ init cmd/adr from flash
\ 
\ ----- cmd/adr default
\ -: cad-def ; \ label for looking at default 
\ 
here constant cad-default  $1f ,  \ cmd=loopback, adr=master
\ 
-: /cad<default  cad-default ##p! @f !cad ; \ init cmd/adr from default
\ 
[then] \ ----------------------------------------------------------------------
\ 
0 [if] \ ------------------------[ rssi ]--------------------------------------
\ 
\ NOTE: For direct cell accounting -- not saved to flash!

cpuHere constant ~rssi_listen 1 cpuAllot  \ listening rssi
cpuHere constant ~rssi_rcv    1 cpuAllot  \ rcv rssi

-: @rssi_listen  ( - n)   ~rssi_listen #@ ;  \ get listen rssi
-: @rssi_rcv     ( - n)   ~rssi_rcv    #@ ;  \ get rcv rssi
-: set_rssi_rcv  @rssi ~rssi_rcv #! ;   \ save listening rssi
-: set_rssi_listen  @rssi ~rssi_listen #! ;   \ save listen rssi
\ 
[then] \ ----------------------------------------------------------------------
\ 
\  
: !   \ user command to save to config block 
   erase-config  
   cz>flash  ascale>flash  ( cmd>flash)  tb>flash  eb>flash  
   mr>flash  ml>flash  cad>flash  f-touched  ;
: %   \ user command  
   /cz<default  /ascale<default ( /cmd<default) /tb<default /eb<default 
   /mr<default /ml<default /cad<default ;

-: /flashers  /cz<flash  /ascale<flash  ( /cmd<flash)  /tb<flash  /eb<flash 
   /mr<flash  /ml<flash  /cad<flash ;
-: /cfg   -touched? ##p! @f 0=if drop /flashers ; then drop % ;    
\ 
\ 
\ dev? [if] \ -----------------[ display config block ]--------------------------
0 [if] \ ----------------------------------------------------------------------
\ 
\ ----- debug
\ : 0test  $77ff ##p! $a5 # !f ;
\ : 1test  config-block ##p!  $5a # !f  p+ p+ $00 # !f p+ p+  $a5 # !f ;

-: (.cfg)  ( n -)  \ display n groups of 16, assumes p is set
            [ 5 push  6 push  7 push ]
   5 #for
      cr p dh. space
      4 #  7 #for 
         space 4 #  6 #for |@p+ h. 6 #next 
      7 #next
   5 #next  [ 7 pop  6 pop  5 pop ] ;

: .cfg   config-block ##p! 32 # (.cfg) cr ;
\ 
[then] \ ----------------------------------------------------------------------
\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( rafl_config.fs         ) . .( bytes) [else] drop [then] 
]
\ 
\ 
0 [if] \ ------------------------[ revisions ]---------------------------------
\ 
Date	   By  Comment
=======	=== ===================================================================
141009   rjn changed names of mode constants (e.g., #loop to #lm)
141009   rjn added error detection/correction on "=" entries
140924   rjn fixed cz= display to show just cz0 and temperature (no cr)
140922   rjn changed m command to m? 
140808   rjn now does variable and flash allotment together
140805   rjn added master/remote flag, message length byte
140804   rjn added terminator and escape byte
140803   rjn cloned from DACS (uses last flash block also)
\ 
[then] \ ----------------------------------------------------------------------
