\ rafl_exchange.fs -- local/remote data exchange -- 140924rjn
\ 
] here ( *start)
\ 
0 [if] \ ---------------------[ test data ]------------------------------------
\ 
-: see-tdata ;  \ allows viewing with "see"
\ 
here constant tdata ( test data)
   $49 , $00 , $00 , $00 , $00 , $00 , $00 , $00 , $00 ,

here [ tdata -  ] constant #tdata  
\ 
: @tdata  tdata ##p!  #tdata #  5 #for |@p+ 5 #next ;
: !tdata  /fifo  /rbuf  @tdata  #tdata #  5 #for !both  5 #next ;
\ 
[then] \ ----------------------------------------------------------------------
\ 
\ ----------------------[ fifo, rbuf, client exchanges ]-----------------------
\ 
-: fifo>rbuf   \ xfr fifo to rbuf, set cmd from master   
   /#fifo ( ?)  /rbuf  plen 5 #for @fifo !rbuf 5 #next 
   @mr if drop @rbuf- >cmd !cmd ; then drop ;  \ only remote needs cmd set 

-: /both   /fifo  /rbuf ;

-: rbuf>fifo   #rbuf  /both  5 #for @rbuf !fifo 5 #next ;   

\ this sends all but the cad byte to the client
-: rbuf>client  #rbuf- /rbuf  5 #for @rbuf emit 5 #next ;
\ 
\ -----------------------------------------------------------------------------
\   
1 [if] \ ---------------------[ receive actions ]------------------------------
\ 
\ -: set_rssi_listen  @rssi ~rssi_listen #! ;   \ save listen rssi
-: set_rssi_listen  @rssi  !rssi_listen ;
\ -: set_rssi_rcv     @rssi ~rssi_rcv    #! ;   \ save rcv rssi
-: set_rssi_rcv  @rssi !rssi_rcv ;

-: !both  ( n -)   dup !fifo !rbuf ;

: -len?  ( - ?)   @ml  #rbuf  xor 0=if ; then drop $ff # ;  \ length met

-: -more?  ( - ?)  \ 0 for no more input chars
   @rbuf- @tb  xor 0=if ; then drop \ terminator
   @rbuf- @eb  xor 0=if ; then drop \ escape
   -len?  ;

-: get_terminal   /both
   0 # begin drop  key dup emit !both  -more? 0=until drop  @cad !both ;

-: get_data   /both
   0 # begin drop  key dup emit !both   -len? 0=until drop  @cad !both ; 
\ 
[then] \ ----------------------------------------------------------------------
\  
\ -: 'irq  string " |irq"
-: .irq  'irq  nirq 0=if. '0 ; then '1 ;

-: tx    ready_mode+  >tx_ant  stabilize_osc 
         +packet_sent_int  /interrupt  tx_mode ; 

-: rx    ready_mode+  >rx_ant  stabilize_osc
         +packet_rcvd_int  /interrupt  rx_mode ;

\ -: 'buf  string "  |buf "
\ -: .#rbuf  #rbuf 'buf h. ;

\ -: .plen  'plen plen h. ;
\ -: ?.plen  @mr 0=if drop .plen ; then drop ;
\ 
-: @rins  0 #  \ assemble remote input status bits
   in0 if. [ 0 .t set ] then
   in1 if. [ 1 .t set ] then 
   in2 if. [ 2 .t set ] then
   in3 if. [ 3 .t set ] then  ;

-: ?.carry  rrc  if' '1 ; then '0 ;

-: r.ins  ( n -)   4 #  4 #for ?.carry 4 #next drop ;        
\ 
-: @ain  ( - d)   p17-select ar ;

-: @ro  ( - n)   3 # @xvar ;   \ $ff=remote output on
-: @mo  ( - n)   4 # @xvar ;   \ $ff=master output on

-: ?@output   @mr 0=if drop @mo ; then drop @ro ;

\ 
-: get_stats   /rbuf      \ assemble stat bytes in rbuf
   @adr         !rbuf         \ master/remote address
   ?@output     !rbuf         \ output status  $ff=output on
   @rins        !rbuf         \ input statuses
\   @ain         !rbuf !rbuf   \ unscaled analog input
   @rssi_listen !rbuf         \ listen rssi 
   @rssi_rcv    !rbuf         \ listen rssi for last msg
   @vb          !rbuf         \ battery voltage
   @vc          !rbuf         \ version code
   @cz0         !rbuf !rbuf   \ Celsius zero crossing
\   depth        !rbuf         \ remote stack depth
   @ascale      !rbuf !rbuf   \ analog scale factor
   vin>rbuf                   \ text for analog voltage
   tmp>rbuf                   \ text for temperature
;

-: @ios  ( - n)  5 # @xvar ;
-: !ios  ( n -)  5 # !xvar ;
-: =stats   $ff # !ios ;
-: =io        0 # !ios ;

-: .adr|  .ad= 'bar ;

-: r.as   9 # !rbuf>  'as=  @rbuf  (h.)  @rbuf  (h.) ;
-: r.cz   7 # !rbuf>  'cz=  @rbuf  (h.)  @rbuf  (h.) ;

-: .status   /rbuf   \ format and display stat data from remote
   @rbuf (.ad=)
   @rbuf @rbuf 2drop  ( @rbuf @rbuf 2drop)  \ skip I/O bytes
   @rbuf 'lss (h.)  @rbuf 'rss (h.)  
   @rbuf 'bat (h.)  @rbuf 'ver (h.)  r.cz
\   'dbg @rbuf (h.) 'bar
   @rbuf @rbuf swap 'as=  (dh.) 'bar
   ;

\ -: rtype  ( n -)   4 #for @rbuf emit 4 #next ;

-: r.tmp   'tmp  16 # !rbuf>  9 #  rtype ;
-: r.vin   'vin  11 # !rbuf>  5 #  rtype ;

-: .io  /rbuf  @rbuf (.ad=)  @rbuf 'out ?.1|0  @rbuf 'ins r.ins
   r.vin  r.tmp  'bar ; 

-: ?.io   @ios 0=if drop .io ; then drop .status ;

-: .x_stats  'lss @rssi_listen (h.) 'rss @rssi_rcv h| 
   cr 'snt .dbuf cr h.dbuf  
   @cmd bm# xor 0=if drop ; then drop cr 'rcv .rbuf  cr h.rbuf ;

-: ?broadcast  @cmd bm# xor 0=if drop 'bm= ; then drop ;

-: (?.packet)   
   @status stat# xor 0=if drop ?.io /status ; then drop 
   @cmd      bm# xor 0=if drop 'bm= .rbuf   ; then drop .rbuf ;

-: ?.packet     @mr 0=if drop (?.packet) ; then drop ;

-: ?.crc_err  ( n -)  @mr 0=if drop cr 'crc_err h. ; then drop drop ;
-: ?.pkt_err  ( n -)  @mr 0=if drop cr 'pkt_err h. ; then drop drop ;

\ After do-packet, the received response is in rbuf, cmd/adr is in cad
-: do-packet  \ process the packet   
   @i_stat1 $02 # and if ( valid packet) drop
      @i_stat1  $01 # and if  ?.crc_err then drop    
      fifo>rbuf  ?.packet ;
   then  ?.pkt_err ;

-: rcv_setup  /fifo rx  set_rssi_listen ;

-: (rcv)   rcv_setup  begin  set_rssi_rcv  nirq 0=until.  do-packet ;

-: nirq?  ( - ?)   nirq if. $ff #  set_rssi_rcv ; then 0 # ;  \ 0=pkt

-: (trcv)   \ receive with timeout
   !3sec  rcv_setup
   0 # begin  drop 100 # |us  ticks? nirq? and 0=until drop
   nirq 0=if. do-packet ; then .ad= 'err 'timeout 'bar ; 

-: ?.dbuf  @mr 0=if drop cr h.dbuf ; then drop ;

-: (send)   rbuf>dbuf  @#fifo ( plen) !payload  tx  begin nirq 0=until. ;

-: send_rbuf   rbuf>fifo  ( 100 # |ms)  (send) ;
\ 
\ -------------------[ terminal, status & data modes ]-------------------------
\ 
-: exchange  (send) (trcv) ;

0 [if]
-: (t)   get_terminal  @rbuf-- @eb xor 0=if drop cr ; then drop cr ;

\ send a line of data, terminate on escape char, EOL character or length
: t   (t) (send) @cmd bcast# xor 0=if drop .rbuf ; then drop (trcv) ;
[then]

\ -: (t)   get_terminal  @rbuf-- @eb xor 0=if drop cr ; then drop cr ;

\ send a line of data, terminate on escape char, EOL character or length
: t   get_terminal  
      @rbuf-- @eb xor 0=if ( esc)  drop ( cr) ; then drop (send) 
      @cmd    bm# xor 0=if ( bcst) drop .rbuf ; then drop cr (trcv) ;

\ send a line of data, terminate on length only
: d   get_data  exchange ;

\ enter continuous "t" mode (no need to prefix lines with a "t")
: tt  0 # begin drop cr t  @rbuf-- @eb xor 0=until drop ;

\ -----[ master/remote status and I/O ]

-: show_ios   get_stats ?.io ;

: ms   =stats  show_ios ;
-: (rs)   @cmd  status /both @ro !both  @cad !both !cmd  exchange ;
: rs   =stats (rs)  ;

: mio  =io  show_ios ;   \ display master I/O
: rio  =io (rs) ;        \ display remote I/O

\ enter analog scaling factor, display results
: as=  (as=)  space ( .as)  get_stats  r.as  r.vin  'bar  ;

\ enter Celsius zero crossing value, display result (set with terminal only)
-: (cz=)  $$? if drop cz0 # !rd ; then drop drop drop ;
: cz=  (cz=) space  get_stats  r.cz  r.tmp  'bar ;

\ query results of last broadcast command (in dbuf)
: b   @cmd  last   /both @cad !both  !cmd  cr exchange 'bar ;

\ show exchange stats for the last xmsn
: x  .x_stats  ;   \ display exchange
\ 
\ -----------------------------------------------------------------------------
\ 
\ -----[ master/remote output ]
\
\ -: @ro  ( - n)  3 # @xvar ;
-: !ro  ( n -)  3 # !xvar ;

-: @mo  ( - n)  4 # @xvar ;
-: !mo  ( n -)  4 # !xvar ;

-: set_mo  $ff # !mo ;
-: clr_mo    0 # !mo ;
-: set_ro  $ff # !ro ;
-: clr_ro    0 # !ro ;
-: //ios  -p21  clr_ro  clr_mo  ;

: ro+   set_ro  rio ;
: ro-   clr_ro  rio ;
: mo+   +p21   set_mo  mio ;
: mo-   -p21   clr_mo  mio ;

-: ?rout   /rbuf @rbuf dup !ro 0=if drop -p21 ; then drop +p21 ;

\ : 0test  !tdata @cmd !both exchange ;  \ test with non-ascii data
\
-: query_client  rbuf>client  sbytes>rbuf  rbuf>dbuf ;
     
-: (do-remote)
   @cmd  ( dup h.)  \ received packet in rbuf, cmd variable set
\ ----- loopback -----
   lm# xor 0=if drop send_rbuf ; then  lm# xor
\ ----- terminal -----
   tm# xor 0=if drop query_client  send_rbuf ; then  tm# xor
\ ----- broadcast message -----
   bm# xor 0=if drop query_client  rbuf>dbuf ; then  bm# xor
\ ----- last message ( b cmd) -----
   last# xor 0=if drop dbuf>rbuf send_rbuf ;   then  last# xor   
\ ----- data mode -----   
   dm# xor 0=if drop query_client  send_rbuf ; then  dm# xor
\ ----- status mode -----   
   stat# xor 0=if drop ?rout  get_stats  send_rbuf ; then  stat# xor 
\ ----- cmd error -----   
   /rbuf *cmd? h>rbuf  send_rbuf ; 

-: ?me  \ check for my address or broadcast
   @cmd bm# xor 0=if drop (do-remote) ; then drop
   @adr @rbuf- mask_adr xor 0=if drop (do-remote) ; then drop ; 

-: do-remote  begin (rcv) ?me again  \ remote in listen/response loop 
\ 
: cfg   .ser .mr .ad= .cmd .eb  .tb  .ml  'bar ;
\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( rafl_exchange.fs       ) . .( bytes) [else] drop [then] 
]
\
\
0 [if] ---------------------[ Revision History ]-------------------------------
\ 
Date	  By  Description
======= === ===================================================================
140924  rjn changed o+ to mo+ and o- to mo-.  Fixed I/O setting/display problem.
140902  rjn addressing cleanup. Now displays address for most modes.
140827  rjn changes to terminal and data mode in (remote), consolidated
               words to exchange data between fifo, rbuf, client
140805  rjn added escape byte and message length
140729  rjn initial version
\ 
[then] \ ----------------------------------------------------------------------
