\ rafl_init.fs -- RAFL I/O initialization -- 140929rjn
\
]  here  \ start marker
\ 
0 [if] ---------------------------[ Notes ]------------------------------------

1. Configures 850 chip.
2. To be called as part of cold so that after a reset the hardware 
    returns to these settings
3. If a bit needs changing in the application, "and/orl" it.
4. 850 I/O assignments (QSOP 24):

         MINT
   Port	Pin Type Function
   ----	--- ---- --------------------------------------------------------------
   P0.0	  7   DI gpio0 - 4432 configured as output on POR
   P0.1	  5   DI gpio1 - 4432 configured as output on POR
   P0.2    3   DI gpio2 - 4432 configured as output on POR
   P0.3	  4   DI 
   P0.4	  6   PP SERIAL TX (output)
   P0.5	  8   DI SERIAL RX (input)
   P0.6   10   DI    
   P0.7	 19   DI 
   P1.0	 14   PP SCK  - SCLK clock input to 4432 (module pin 8)
   P1.1	 16   PP MOSI - SDI serial data in to 4432 (module pin 7)
   P1.2   18   DI MISO - SDO serial data out from 4432 (module pin 6)
   P1.3	 20   PP NSS  - (reserved for H/W SPI)
   P1.4	 22   PP NSEL - serial input select to 4432 (module pin 9)
   P1.5	 21   DI NIRQ - irq output from 4432 (module pin 10)
   P1.6   19   PP SDN  - shutdown (module pin 11) 
   P1.7   17   PP 
   P2.0   15   BD C2D
   P2.1   23   PP 
        2,24   -- GND
           1   -- VDD (5 Volts)
          13   -- RST/C2CK (to C2CK on pin 4 of BOBI interface)  
\ 
[then] \ ----------------------------------------------------------------------
\ 
0 [if] \ -------------------[ I/O initialization ]-----------------------------

 1. Steps for port I/O initialization, per datasheet:
	Step 1 - Select input mode (analog or digital) for all port pins
		 using PnMDIN.  If the pin is in analog mode, a "1" must also
		 be written to the corresponding Port Latch.  Default for
		 PnMDIN is $ff (pins not configured as analog inputs).
	Step 2 - Select the output mode using PnMDOUT.  
		  Output Modes - 0=open drain, 1=push pull
	Step 3 - Assign port pins to desired peripherals using XBRn registers.
	Step 4 - Enable the crossbar (XBARE="1")
2. Pins used as comparator or ADC inputs should be configured as analog inputs.
3. Analog input pins should be skipped by the crossbar.
4. All analog pins must have a "1" set in the corresponding Port Latch reg.

[then] \ ----------------------------------------------------------------------
\ 
0 [if] \ ----------------------[ I/O Checkout ]--------------------------------
\ 
\ use with interpreter to wiggle I/O pins
: ~00  [ 0 .p0 toggle ] ;
: ~01  [ 1 .p0 toggle ] ;
: ~02  [ 2 .p0 toggle ] ;
: ~03  [ 3 .p0 toggle ] ;
\ : ~04  [ 4 .p0 toggle ] ;
\ : ~05  [ 5 .p0 toggle ] ;
: ~06  [ 6 .p0 toggle ] ;
: ~07  [ 7 .p0 toggle ] ;
: ~10  [ 0 .p1 toggle ] ;
: ~11  [ 1 .p1 toggle ] ;
: ~12  [ 2 .p1 toggle ] ;
: ~13  [ 3 .p1 toggle ] ;
: ~14  [ 4 .p1 toggle ] ;
: ~15  [ 5 .p1 toggle ] ;
: ~16  [ 6 .p1 toggle ] ;
: ~17  [ 7 .p1 toggle ] ;
: ~20  [ 0 .p2 toggle ] ;
: ~21  [ 1 .p2 toggle ] ;
: +p1  $00 # p0 #! ;
: -p1  $ff # p0 #! ;
\ 
[then] \ ----------------------------------------------------------------------
\ 
1 [if] \ -----------------------[ user I/O ]-----------------------------------
\ 
\ -----[ output ]
:m out  [ 1 .p2 ] m;
: +p21   [ out  set ] ;
: -p21   [ out  clr ] ;
\ 
\ -----[ inputs ]
:m in0   [ 3 .p0 ] m;
:m in1   [ 6 .p0 ] m;
:m in2   [ 7 .p0 ] m;
:m in3   [ 3 .p1 ] m;
\ 
\ -----[ analog input ]
:m ain   [ 7 .p1 ] m;
\ 
[then] \ ----------------------------------------------------------------------

1 [if] \ -----------------------[ 4432 I/O ]-----------------------------------
\ 
:m sclk  [ 0 .p1 ] m; \ PP SCLK
:m mosi  [ 1 .p1 ] m; \ PP to SDI
:m miso  [ 2 .p1 ] m; \ DI from SDO
:m nsel  [ 4 .p1 ] m; \ PP chip select
:m nirq  [ 5 .p1 ] m; \ DI from irq line
:m sdn   [ 6 .p1 ] m; \ PP shutdown (1=shutdown, 0=power up)
:m gpio0 [ 0 .p0 ] m; \ DI from 4432
:m gpio1 [ 1 .p0 ] m; \ DI from 4432
:m gpio2 [ 2 .p0 ] m;
\ 
[then] \ ----------------------------------------------------------------------
\ 
\ ---------------------------[ interrupts ]------------------------------------
\ 
:m |disable-interrupts  [ 7 .IE clr ] m;
:m |enable-interrupts   [ 7 .IE set ] m;
:m -int  |disable-interrupts m;
:m +int  |enable-interrupts m;
\ 
\ ---------------------[ flash setup/read/write ]------------------------------
\ 
:m write-setup   \ common code for write & erase
	|disable-interrupts
	$A5 # FLKEY #! \ write first key byte
	$F1 # FLKEY #! \ write second key byte
m; 

:m +write   \ setup for flash write
\	$01 ~# PFE0CN and!  \ clear FLBWE for single byte writes
	write-setup
	$01 # PSCTL #! \ set PSWE, enable write, not erase
m;

:m +erase  \ setup for flash page erase
	write-setup
	$03 # PSCTL #!	\ set PSWE & PSEE, enable write & erase
m;	

:m -write  \ finish flash erase or write
	$00 # PSCTL #!	\ clear PSWE & PSEE to disable erase/write
   |enable-interrupts
m;
\ 
-: /chip
\ 
\ -----[ disable watchdog ]
\ 
   |disable-interrupts
   $de # WDTCN #!     \ disable watchdog
   $ad # WDTCN #! 
\ 
\ ----- [setup serial port]
\ 
   $00 # CLKSEL #!   \ internal 24.5 MHz oscillator, SYSCLK/1
   $00 # CKCON #!    \ T1 uses SYSCLK/12
\   $08 # CKCON #!     \ T1 uses SYSCLK (i.e., for 115200 baud)
	$12 # SCON0 #!    \ enable RCV, transmit interrupt enabled
	$20 # TMOD #!     \ mode 2, 8-bit auto-reload
\	 $96 # TH1 #!       \ 9600 baud, or 115200 with T1 using SYSCLK (24.5 MHz)
   $cc # TH1 #!      \ 19.2K baud, 24.5 MHz
	6 .TCON set       \ enable Timer 1
\	$f1 # TMOD and! $01 # TMOD ior! \ 16 bit timer 0
   |enable-interrupts
\ 
\ -----[ configure I/O ] 
\ 
   $00 # XBR2 #!     \ disable xbr
\ 
\ ----- port 0
   $10 # P0MDOUT #!  \ P0[4] push/pull
\ ----- port 1
   $80 # P1SKIP  #!  \ skip P1[7] (analog)
   $7f # P1MDIN  #!  \ set P1[7] as analog input
   $5b # P1MDOUT #!  \ P1[2,5,7] inputs
\ ----- port2   
   $ff # P2MDOUT #!  \ P2[0,1] push pull -- C2D
\ 
\   $07 # PRTDRV #!      \ enable all as high drive (default)
\ 
   $01 # XBR0 #!     \ UART enabled
\   $00 # XBR1 #!        \ no resources routed to port pins (default)
\   $c0 # XBR2 #!        \ enable XBR, weak pullups disabled
   $40 # XBR2 #!        \ enable XBR, weak pullups
\ 
\ -----[ init application I/O ]
\ 
\ note: must write 1s to digital inputs at startup
\ 
   [ gpio0 set  gpio1 set  5 .p0 set ( serial input) 
     miso  set  nirq  set  sclk clr  nsel clr  
     in0   set  in1   set  in2  set  in3  set ]  -p21 ;
\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( rafl_init.fs            ) . .( bytes) [else] drop [then] 
]
\ 
0 [if] ---------------------[ Revision History ]-------------------------------
\ 
Date	  By  Description
======= === ===================================================================
140929  rjn /init now does what bootloader used to do
140905  rjn added words to manage p2.1 (transistor output)
140721  rjn initial version from DACS, updated connection table for MINT pinout
\ 
[then] \ ----------------------------------------------------------------------

