\ rafl_serial2xram.fs -- capture serial output to xram -- 140816rjn
\
] here ( *start)
\
\ use double number ticks timer
\ -: !65secs  $ffff ## !ticks ;  \ for ~1 ms per tick
-: !receive_timeout  $1388 ## ( 5 secs) !ticks ;  \ max wait for char stream

\ -----[ maximum delay between chars ]
-: !cto  100 ## !ticks ;  \ char timeout ~ 100 ms (~10 chars at 1200 baud)

-: ?!rbuf ( n -)  \ store chr in rbuf, check for cr, length termination.
   dup !rbuf  drop $0d # xor 0=if drop /ticks ; then drop
   #rbuf  ( @len) 10 #  negate + -if drop !cto ; then drop /ticks ; 

-: sbytes>rbuf   \ get DACS output, put in xram
   /rbuf  !receive_timeout  [ 0 .SCON clr ]
   0 # begin drop
      0 .SCON if. ( char rdy) key ?!rbuf then 
   @ticks ior 0=until drop ;

0 [if] \ --------------------[ keyboard test ]---------------------------------
\ 
\ -----[ maximum delay between chars ]
-: !xto  $1388 ## !ticks ;  \ 5 second inter-char timeout

-: ?!rbuf ( n -)  \ check for end of chars
   dup !rbuf  $0d # xor 0=if drop /ticks ; then drop
   #rbuf  @len  negate + -if drop !xto   ; then drop /ticks ( bail) ; 

: xxx  \ test from keyboard
   /rbuf  $2710 ## !ticks  \ 10 secs to start entering chars
   0 # begin drop
      0 .SCON if. ( char rdy) key dup emit ?!rbuf then 
   @ticks ior 0=until drop cr h.rbuf ; 
\    
[then] \ ----------------------------------------------------------------------

\ 
\ -----[ conditional compilation summary ]
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( rafl_serial2xram.fs     ) . .( bytes) [else] drop [then] 
]
\ 
\ 
0 [if] \ ---------------------[ Revision History ]-----------------------------
\ 
Date	  By  Description
======= === ===================================================================
140816  rjn initial version
\ 
[then] \ ----------------------------------------------------------------------

