\ rafl_timer0.fs -- millisecond tick timer -- 140825rjn
\
] here ( *start)
\
\ -----[ interrupt enable/disable ] 
\ :m |disable-interrupts  [ 7 .IE clr ] m;
\ :m |enable-interrupts   [ 7 .IE set ] m;
\ :m -int  |disable-interrupts m;  \ now in bootloader
\ :m +int  |enable-interrupts m;

:m |start-T0  
	[ 4 .TCON set ]   \ start timer 0   
	[ 1 .IE   set ]   \ enable overflow interrupt 
m;

-: start-T0  |start-T0 ;

:m |stop-T0   [ 4 .TCON clr  ( 5 .TCON clr) ]  m;
-: stop-T0   |stop-T0 ;

:m save-state  \ ~ 80 ns per instruction, ~ 960 ns total
   [ t push  psw push  $82 push ( DPL)  DPH push  
     0 push  1 push  2 push  3 push  4 push  5 push  6 push  7 push ] m; 

:m restore-state  \ ~ 80 ns per instruction
   [ 7 pop  6 pop  5 pop  4 pop  3 pop  2 pop  1 pop  0 pop  
     DPH pop  $82 pop  psw pop  t pop ] m;
\
1 [if] \ --------------------------[ 1 ms tick timer ]-------------------------
\ 
\ double number countdown, no rollover to $ffff
\ max tick delay is ~ 65 seconds with 1 ms ISR
\ 
cpuHERE constant mticks 1 cpuALLOT  \ ticks msb
cpuHERE constant lticks 1 cpuALLOT  \ ticks lsb
\ 
:m tick-  [ lticks t mov ] 0=if [ mticks dec ] then [ lticks dec ] m;  
:m |ticks-  [ mticks t mov  lticks $45 ] , , if tick- then m;
:m !ticks  ( d -)  -int mticks #!  lticks #! +int m;
:m @ticks  ( - d)  -int lticks #@  mticks #@ +int m;
:m /ticks   0 ## !ticks  m;
:m |ticks?  @ticks ior m;  \ any ticks left?  (0 for timed out)
-: ticks?  |ticks? ;

:m !1sec   $03e8 ## !ticks m;
:m !2sec   $07d0 ## !ticks m;
:m !3sec   $0bb8 ## !ticks m;
:m !5sec   $1388 ## !ticks m;
:m !65sec  $ffff ## !ticks m;
:m !100ms  $0064 ## !ticks m;
:m !200ms  $00c8 ## !ticks m;
:m !500ms  $01f4 ## !ticks m;

-: wait   0 # begin drop  |ticks? 0=until drop ;
-: 1sec   !1sec wait  ;
\ 
[then] \ ----------------------------------------------------------------------
\ 
0 [if] \ ---------------------[ ticks test ]-----------------------------------
\ 
-: (aaaa)  [ mticks t mov  lticks $45 ] , , ;
: aaa  $c33c ## !ticks   0 #  (aaaa) h.  ; 

-: !receive_timeout  $2710 ## ( 10 secs) !ticks ;  \ max wait for char stream

: bbb  
   $2710 ## ( ~10 secs) !ticks  0 # begin drop @ticks ior 0=until drop
   cr [ char ! ] # emit ;
\ 
[then] \ ----------------------------------------------------------------------
\ 
\ 
TIM0 interrupt : timer0-isr
	-int
   |stop-T0
\   [ 4 .P0 set ]  \ for timing
\   save-state         \ ~960 ns (not needed, just doing ticks)
   [ t push ]      \ save tos
   |ticks-         \ tick timer (trashes t)
   [ t pop ]       \ restore tos
\   restore-state      \ ~960 ns
	$F7 # TH0 #!  $ff # TL0 #!  \ reload timer, ~  1 ms
\   [ 4 .P0 clr ]  \ for timing
   |start-T0        
   +int
   reti
\
-: 16_bit_timer  $f1 # TMOD and! $01 # TMOD ior! ;

-: /timer0  -int  16_bit_timer  |start-T0  +int ;

0 [if] \ -------------------------[ FYI ]--------------------------------------
\ 
	$FF # TH0 #!  $40 # TL0 #!  \ reload timer, ~100 us
	$FF # TH0 #!  $09 # TL0 #!  \ reload timer, ~125 us
	$FE # TH0 #!  $0A # TL0 #!  \ reload timer, ~250 us
	$F8 # TH0 #!  $FF # TL0 #!  \ reload timer, ~884 us
	$F7 # TH0 #!  $FF # TL0 #!  \ reload timer, ~  1 ms
	$F0 # TH0 #!  $09 # TL0 #!  \ reload timer, ~  2 ms
\    
[then] \ ----------------------------------------------------------------------		
\ 
\ 
\ -----[ conditional compilation summary ]
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( rafl_timer0.fs         ) . .( bytes) [else] drop [then] 
]
\ 
\ 
0 [if] \ ---------------------[ Revision History ]-----------------------------
\ 
Date	  By  Description
======= === ===================================================================
140825  rjn added 1sec and ticks?
140814  rjn initial version
\ 
[then] \ ----------------------------------------------------------------------

