\ rafl_xram.fs -- xram words for RAFL -- 140826rjn
\ 
] here ( *start)
\ 
0 [if] \ -----------------------[ Notes ]--------------------------------------
\ 
1. Clipped to $3f, max size of 4432 fifo buffer
2. Change /rbuf to set start of buffer to any place in xram (0 for now)
\ 
[then] \ ----------------------------------------------------------------------
\ 
cpuHere constant rbuf> 1 cpuAllot  \ current offset within ram buffer

0 constant rstart  \ start of rbuf

-: !rbuf>  ( n -)   rbuf> #! ;
-: /rbuf  rstart # !rbuf> ;  \ start of xram ($00-$3f)
-: rbuf+  [ rbuf> inc ] ;
:m rclip  ( n - n')   $3f # and m;
-: @rbuf>  rbuf> #@ ;
-: #rbuf  @rbuf> ;
\ -: .#rbuf  #rbuf h. space ;
-: >rbuf  @rbuf>  rclip  0 #  p! ;
-: !rbuf   ( n -)   >rbuf  !x  rbuf+ ;
-: @rbuf   ( - n)   >rbuf  @x  rbuf+ ;
-: (@buf-)  ( offset - n)   -if 0 # ; then 0 # p! @x ;
-: #rbuf-   #rbuf 1- ;
-: #rbuf--  #rbuf 1- 1- ;
-: @rbuf-  ( - n)   #rbuf-  (@buf-) ;  \ last byte written
-: @rbuf-- ( - n)   #rbuf-- (@buf-) ;  \ next to last byte written

-: rspace  $20 # !rbuf ;
-: rcr     $0d # !rbuf ;
\ 
-: rtype  ( n -)   4 #for @rbuf emit 4 #next ;  \ show n chars from rbuf
\ 
-: $>rbuf  ( a -)  p! |@p+  5 #for @p+ |p push push !rbuf pop pop p! 5 #next ;
\ 
1 [if] \ ---------[ example: put error string & value in rbuf ]----------------
\ 
here [ 2 + ]  \ adr of count byte for string that will be compiled next
-: 'cmd?    string " cmd? "
-: *cmd?  ## $>rbuf ;
\ : ce-test  /rbuf  *cmd?  $ab # h>rbuf  cr h.rbuf cr .rbuf ;
\ 
[then] \ ----------------------------------------------------------------------
\ 
here [ 2 + ]
-: '?          string " ? "
-: *?  ## $>rbuf ;
-: '!?  $aa # emit ;
\ 
-: |h   ( n -)  'bar (h.) ;
-: |h|  ( n -)  |h 'bar ;
-: h|   ( n -)  (h.) 'bar ;
\ 
\ display only ascii, show highlighted ? if not ascii 
-: ?.  ( n -)   dup $1f # <if drop drop '!? ; then drop
                dup $7e # <if drop emit ; then drop drop '!? ;

-: (.rbuf)  ( n -)  
   /rbuf  5 #for @rbuf ?. 5 #next ( rbuf+) ;
-: .rbuf  #rbuf rclip if (.rbuf) ; then drop ;  

-: (h.rbuf)  ( n -)   
   dup h. /rbuf  5 #for @rbuf |h  5 #next 'bar ;
-: h.rbuf  #rbuf rclip if (h.rbuf) ; then drop ;

-: h>rbuf  ( n -)   h>ascii !rbuf !rbuf ;
\ : htest  /rbuf  $ab # h>rbuf  cr h.rbuf  cr .rbuf ; 
\ 
1 [if] \ ---------------[ dbuf: xram display buffer ]--------------------------
\ 
cpuHere constant dbuf> 1 cpuAllot  \ current offset within display buffer

$40 constant dstart  \ start of display buffer, after rbuf ($40-$7f)

-: /dbuf  dstart # dbuf> #! ;
-: dbuf+  [ dbuf> inc ] ;
:m dclip  ( n - n')   $7f # and m;
-: @dbuf>  dbuf> #@ ;
-: #dbuf  @dbuf>  dstart # negate + ;
\ -: .#dbuf  #dbuf h. space ;
-: >dbuf  @dbuf>  dclip  0 #  p! ;
-: !dbuf   ( n -)   >dbuf  !x  dbuf+ ;
-: @dbuf   ( - n)   >dbuf  @x  dbuf+ ;
\ -: (@buf-)  ( offset - n)   -if 0 # ; then 0 # p! @x ;
-: #dbuf-   #dbuf 1- ;
-: #dbuf--  #dbuf 1- 1- ;
-: @dbuf-  ( - n)   #dbuf-  (@buf-) ;  \ last byte written
-: @dbuf-- ( - n)   #dbuf-- (@buf-) ;  \ next to last byte written
\ 
-: (.dbuf)  ( n -)  
   /dbuf  4 #for @dbuf ?. 4 #next ;
-: .dbuf  #dbuf dclip if (.dbuf) ; then drop ;  
\ -: .dbuf+  #dbuf dclip if (.dbuf) ; then drop ;  

-: (h.dbuf)  ( n -)   
   dup h. /dbuf  4 #for @dbuf |h  4 #next 'bar ;
-: h.dbuf  #dbuf dclip if (h.dbuf) ; then drop ;

-: /bufs  /rbuf  /dbuf ;
-: rbuf>dbuf  #rbuf /bufs  6 #for @rbuf !dbuf 6 #next ;
-: dbuf>rbuf  #dbuf /bufs  6 #for @dbuf !rbuf 6 #next ;

-: h>dbuf  ( n -)   h>ascii !dbuf !dbuf ;
\ 
[then] \ ----------------------------------------------------------------------
\ 
0 [if] \ ---------------------[ buffer testing ]-------------------------------
\ 
: fill-rbuf  /rbuf  [ char @ ] #   $3f #  4 #for 1+ dup !rbuf 4 #next drop ;
: fill-dbuf  /dbuf  [ char @ ] #   $3f #  4 #for 1+ dup !dbuf 4 #next drop ; 
\ 
[then] \ ----------------------------------------------------------------------
\ 
1 [if] \ ---------------------[ xram variables ]-------------------------------
\ 
cpuHere constant xvar> 1 cpuAllot  \ offset of current variable

$80 constant xstart  \ start of xram variables

-: >xvar  ( i -)     xstart # +  0 # p! ;
-: @xvar  ( i - n)   >xvar  @x ;
-: !xvar  ( n i -)   >xvar  !x ;

-: @rssi_listen  ( - n)   0 # @xvar ;   
-: !rssi_listen  ( n -)   0 # !xvar ;

-: @rssi_rcv  ( - n)   1 # @xvar ;   
-: !rssi_rcv  ( n -)   1 # !xvar ;

-: @status  ( - n)  2 # @xvar ;
-: !status  ( n -)  2 # !xvar ;
-: /status  0 # !status ;

\ -: @ro  ( - n)  3 # @xvar ;
\ -: !ro  ( n -)  3 # !xvar ;
\ -: /ro  0 # !ro ;

\ -: @mo  ( - n)  4 # @xvar ;
\ -: !mo  ( n -)  4 # !xvar ;
\ -: /mo  0 # !mo ;

\ -: @ios  ( - n)  5 # @xvar ;
\ -: !ios  ( n -)  5 # !xvar ;
\ -: /ios  0 # !ios ;

\ 
[then] \ ----------------------------------------------------------------------
\ 
\ 
\ if using min, take care.  A negative value is not treated as less than 0
\ : 0rjn  $3e #  $3f # min ;  \ $3e
\ : 1rjn  $3f #  $3f # min ;  \ $3f
\ : 2rjn  $40 #  $3f # min ;  \ $3f
\ : 3rjn  $80 #  $3f # min ;  \ $3f ?
\ : 4rjn  $80 #    0 # max ;  \ 0
\ : 5rjn  $80 #    0 # min ;  \ 0 ?      
\ 
\ -----[ conditional compilation summary ]
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( rafl_xram.fs           ) . .( bytes) [else] drop [then] 
]
\
\
0 [if] ---------------------[ Revision History ]-------------------------------
\ 
Date	  By  Description
======= === ===================================================================
140830  rjn added dbuf, cleaned up pointer logic, added xram variables
140826  rjn added #rbuf- & #rbuf--, fixed stack err on (@rbuf-).
140823  rjn removed !r> from .rbuf and h.rbuf -- @rbuf increments the pointer
140813  rjn eliminated "min" and separated out buffer display words
140802  rjn changed rbuf_emit to .rbuf
140801  rjn initial version
\ 
[then] \ ----------------------------------------------------------------------
