\ sfr85x_140422.fs -- 85x SFR assignments -- 16Aug13 rjn
\ 
0 [if]  \ ------[ misc8051 definitions, valid for all pages ]
$82 constant DPL $83 constant DPH
$98 constant SCON : .SCON SCON + ;
$99 constant SBUF
$80 constant P0 : .P0 P0 + ;
$90 constant P1 : .P1 P1 + ;
$a0 constant P2 : .P2 P2 + ;
$b0 constant P3 : .P3 P3 + ;
$81 constant SP
$d0 constant PSW : .PSW PSW + ;
$88 constant TCON : .TCON TCON + ;
$89 constant TMOD
$8a constant TL0 $8b constant TL1
$8c constant TH0 $8d constant TH1
$87 constant PCON  \ changed from $8f -- 04Sep09 rjn
$a8 constant IE : .IE IE + ;
$b8 constant IP : .IP IP + ;
$f0 constant B  : .B  B + ;
[then] \ ----------------------------------------------------------------------
\ 
\ -----[ port drive strength ]
\ 
$f6 constant PRTDRV  \ port drive strength
\ 
\ -----[ P0 ]
$fe constant P0MASK  \ port 0 mask
$fd constant P0MAT   \ port 0 match
$f1 constant P0MDIN  \ port 0 input mode
$a4 constant P0MDOUT \ port 0 output mode 
$d4 constant P0SKIP  \ port 0 skip
\ 
\ -----[ P1 ]
\ 
$ee constant P1MASK  \ port 1 mask
$ed constant P1MAT   \ port 1 match
$f2 constant P1MDIN  \ port 1 input mode
$a5 constant P1MDOUT \ port 1 output mode
$d5 constant P1SKIP  \ port 1 skip
\ 
\ -----[ P2 ]
\ 
\ $b2 constant P2MASK
\ $f3 constant P2MDIN  
$a6 constant P2MDOUT    \ port 2 output mode
\ $b1 constant P2MAT
\ $d6 constant P2SKIP
\ 
\ -----[ Timer 0 ]
\ 
$8c constant TH0
$8a constant TL0
\ 
\ -----[ Timer 1 ]
\ 
$8d constant TH1
$8b constant TL1
\ 
\ -----[ Timer 2 ]
\ 
$c8 constant TMR2CN      \ Timer/counter 2 control
[ : .TMR2CN TMR2CN + ; ] \ bit addressable
$ca constant TMR2RLL     \ Timer/counter 2 reload register, low byte
$cb constant TMR2RLH     \ Timer/counter 2 reload register, high byte
$cc constant TMR2L       \ Timer/counter 2 low byte
$cd constant TMR2H       \ Timer/counter 2 high byte
\ 
\ -----[ Timer 3 ]
\ 
$91 constant TMR3CN      \ Timer 3 control
$92 constant TMR3RLL     \ Timer 3 reload low byte
$93 constant TMR3RLH     \ Timer 3 reload high byte
$94 constant TMR3L       \ Timer 3 low byte
$95 constant TMR3H       \ Timer 3 high byte
\ 
\ ----[ ADC ]
\ 
$b3 constant ADC0AC     \ ADC0 accumulator configuration
$e8 constant ADC0CN0	   \ ADC0 control 0
[ : .ADC0CN0 ADC0CN0 + ; ] \ bit addressable

$b2 constant ADC0CN1    \ ADC0 control 1
$bc constant ADC0CF     \ ADC0 configration
$bd constant ADC0L      \ ADC0 data word low
$be constant ADC0H      \ ADC0 data word high
$c3 constant ADC0GTL    \ ADC0 "greater than" low byte
$c4 constant ADC0GTH    \ ADC0 "greater than" high byte
$c5 constant ADC0LTL    \ ACD0 "less than" low byte
$c6 constant ADC0LTH    \ ADC0 "less than" high byte
$bb constant ADC0MX     \ ADC0 mux selection 
$df constant ADC0PWR    \ ADC0 power control
$b9 constant ADC0TK     \ ADC0 burst mode track time
\ 
\ -----[ comparators ]
\ 
$bf constant CPT1CN     \ comparator 1 control
$9b constant CPT0CN     \ comparator 0 control
$ab constant CPT1MD     \ comparator 1 mode
$9d constant CPT0MD     \ comparator 0 mode
$aa constant CPT1MX     \ comparator 1 mux selection
$9f constant CPT0MX     \ comparator 0 mux selection
\ 
\ -----[ clock ]
$a9 constant CLKSEL  	\ Clock select
$8e constant CKCON   	\ clock control
\ 
\ -----[ UART ]
\ 
\ defined in misc8051_140220.fs
\ $98 constant SCON0 : .SCON0  SCON0 + ;     \ UART0 control
\ $99 constant SBUF0      \ UART0 data buffer
\ 
\ -----[ SPI ]
\ 
$f8 constant SPI0CN     \ SPI0 control
$a1 constant SPI0CFG    \ SPI0 configuration
$a2 constant SPI0CKR    \ SPI0 clock rate control
$a3 constant SPI0DAT    \ SPI0 data
\ 
\ -----[ oscillator ]
\ 
$c7 constant OSCICL     \ high frequency oscillator calibration
$b1 constant OSCLCN  	\ low frequency oscillator control
\ 
\ -----[ flash ]
\ 
$b7 constant FLKEY      \ flash lock and key
\ 
\ -----[ SMBus ]
\ 
$d6 constant SMB0ADM    \ SMBus0 slave address mask
$d7 constant SMB0ADR    \ SMBus0 slave address
$c0 constant SMB0CN     \ SMBus0 control
$c1 constant SMB0CF     \ SMBus0 configuration
$c2 constant SMB0DAT    \ SMBus0 data
$ac constant SMB0TC     \ SMBus0 timing and pin control
\ 
\ -----[ PCA, all pages ]
\ 
$d8 constant PCA0CN
[ : .PCA0CN  PCA0CN + ; ] \ bit addressable
$9e constant PCA0CENT   \ PCA center alignment enable
$9c constant PCA0CLR    \ PCA comparator clear control
$d9 constant PCA0MD     \ PCA mode
$96 constant PCA0POL    \ PCA output polarity
$f7 constant PCA0PWM    \ PCA PWM configuration
$f9 constant PCA0L   	\ PCA counter low
$fa constant PCA0H   	\ PCA counter high
$fb constant PCA0CPL0   \ capture module low byte 0
$e9 constant PCA0CPL1   \ capture module low byte 1
$eb constant PCA0CPL2   \ capture module low byte 2
$fc constant PCA0CPH0   \ capture module high byte 0
$ea constant PCA0CPH1   \ capture module high byte 1
$ec constant PCA0CPH2   \ capture module high byte 2
$da constant PCA0CPM0   \ capture/compare mode 0
$db constant PCA0CPM1   \ capture/compare mode 1
$dc constant PCA0CPM2   \ capture/compare mode 1?
\ 
\ -----[ CRC ]
\ 
$d2 constant CRC0AUTO   \ CRC0 automatic control
$ce constant CRC0CN     \ CRC0 control
$d3 constant CRC0CNT    \ CRC0 automatic flash sector count  
$de constant CRC0DAT    \ CRC0 data output
$cf constant CRC0FLIP   \ CRC0 bit flip
$dd constant CRC0IN     \ CRC0 data input
\ 
\ -----[ VDD monitor ]
\ 
$ff constant VDM0CN     \ supply monitor control
\ 
\ -----[ watchdog ]
\ 
$97 constant WDTCN      \ watchdog timer control
\ 
\ -----[ voltage reference ]
\ 
$d1 constant REF0CN     \ Voltage reference control
$c9 constant REG0CN     \ Voltage regulator control
\ 
\ -----[ crossbar ]
\ 
$e1 constant XBR0       \ crossbar 0
$e2 constant XBR1       \ crossbar 1
$e3 constant XBR2       \ crossbar 2
\  
\ -----[ misc. ]
\ 
$ad constant DERIVID    \ derivitive identification
$b5 constant DEVICEID   \ device id SFR (contains $30 for an 850 chip)
$8f constant PSCTL      \ program store control
$ef constant RSTSRC     \ reset source
$b6 constant REVID      \ revision identification
\ 
\ -----[ extended interrupts ]
\ 
$f3 constant EIP1       \ extended interrupt priority 1
$e6 constant EIE1       \ extended interrupt enable 1
$e4 constant IT01CF     \ interrupt 0/1 configuration
\ 
0 [if] \ -------------------[ Bit Definitions ]--------------------------------
\ 
; ADC0CN0 0xE8
AD0EN                BIT  ADC0CN0.7   ;
BURSTEN              BIT  ADC0CN0.6   ;
AD0INT               BIT  ADC0CN0.5   ;
AD0BUSY              BIT  ADC0CN0.4   ;
AD0WINT              BIT  ADC0CN0.3   ;
ADC0M2               BIT  ADC0CN0.2   ;
ADC0M1               BIT  ADC0CN0.1   ;
ADC0M0               BIT  ADC0CN0.0   ;

; IE 0xA8
EA                   BIT  IE.7        ; Global Interrupt Enable
ESPI0                BIT  IE.6        ; Serial Peripheral Interface Enable
ET2                  BIT  IE.5        ; Timer 2 Interrupt Enable
ES0                  BIT  IE.4        ; Serial Port Interrupt Enable
ET1                  BIT  IE.3        ; Timer 1 Interrupt Enable
EX1                  BIT  IE.2        ; External Interrupt Enable
ET0                  BIT  IE.1        ; Timer 0 Interrupt Enable
EX0                  BIT  IE.0        ; External Interrupt 0 Enable

; IP 0xB8
                                      ; bit 7 UNUSED
PSPI0                BIT  IP.6        ; Serial Peripheral Interface Priority
PT2                  BIT  IP.5        ; Timer 2 Priority
PS0                  BIT  IP.4        ; Serial Port Priority
PT1                  BIT  IP.3        ; Timer 1 Priority
PX1                  BIT  IP.2        ; External Interrupt 1 Priority
PT0                  BIT  IP.1        ; Timer 0 Priority
PX0                  BIT  IP.0        ; External Interrupt 0 Priority

; PCA0CN 0xD8
CF                   BIT  PCA0CN.7    ; PCA 0 Counter Overflow Flag
CR                   BIT  PCA0CN.6    ; PCA 0 Counter Run Control Bit
                                      ; bit 5 UNUSED
                                      ; bit 4 UNUSED
                                      ; bit 3 UNUSED
CCF2                 BIT  PCA0CN.2    ; PCA 0 Module 2 Interrupt Flag
CCF1                 BIT  PCA0CN.1    ; PCA 0 Module 1 Interrupt Flag
CCF0                 BIT  PCA0CN.0    ; PCA 0 Module 0 Interrupt Flag

; PSW 0xD0
CY                   BIT  PSW.7       ; Carry Flag
AC                   BIT  PSW.6       ; Auxiliary Carry Flag
F0                   BIT  PSW.5       ; User Flag 0
RS1                  BIT  PSW.4       ; Register Bank Select 1
RS0                  BIT  PSW.3       ; Register Bank Select 0
OV                   BIT  PSW.2       ; Overflow Flag
F1                   BIT  PSW.1       ; User Flag 1
P                    BIT  PSW.0       ; Accumulator Parity Flag

; SCON0 0x98
S0MODE               BIT  SCON0.7     ; Serial Mode Control Bit 0
                                      ; bit 6 UNUSED
MCE0                 BIT  SCON0.5     ; Multiprocessor Communication Enable
REN0                 BIT  SCON0.4     ; Receive Enable
TB80                 BIT  SCON0.3     ; Transmit Bit 8
RB80                 BIT  SCON0.2     ; Receive Bit 8
TI0                  BIT  SCON0.1     ; Transmit Interrupt Flag
RI0                  BIT  SCON0.0     ; Receive Interrupt Flag

; SMB0CN 0xC0
MASTER0              BIT  SMB0CN.7    ; SMBus Master/Slave Indicator
TXMODE0              BIT  SMB0CN.6    ; SMBus Transmit Mode Indicator
STA0                 BIT  SMB0CN.5    ; SMBus Start Flag
STO0                 BIT  SMB0CN.4    ; SMBus Stop Flag
ACKRQ0               BIT  SMB0CN.3    ; SMBus Acknowledge Request
ARBLOST0             BIT  SMB0CN.2    ; SMBus Arbitration Lost Indicator
ACK0                 BIT  SMB0CN.1    ; SMBus Acknowledge
SI0                  BIT  SMB0CN.0    ; SMBus Interrupt

; SPI0CN 0xF8
SPIF                 BIT  SPI0CN.7    ; SPI 0 Interrupt Flag
WCOL                 BIT  SPI0CN.6    ; SPI 0 Write Collision Flag
MODF                 BIT  SPI0CN.5    ; SPI 0 Mode Fault Flag
RXOVRN               BIT  SPI0CN.4    ; SPI 0 RX Overrun Flag
NSSMD1               BIT  SPI0CN.3    ; SPI 0 NSS Mode Bit 1
NSSMD0               BIT  SPI0CN.2    ; SPI 0 NSS Mode Bit 0
TXBMT                BIT  SPI0CN.1    ; SPI 0 Transmit Buffer Empty Flag
SPIEN                BIT  SPI0CN.0    ; SPI 0 SPI Enable

; TCON 0x88
TF1                  BIT  TCON.7      ; Timer 1 Overflow Flag
TR1                  BIT  TCON.6      ; Timer 1 On/Off Control
TF0                  BIT  TCON.5      ; Timer 0 Overflow Flag
TR0                  BIT  TCON.4      ; Timer 0 On/Off Control
IE1                  BIT  TCON.3      ; Ext. Interrupt 1 Edge Flag
IT1                  BIT  TCON.2      ; Ext. Interrupt 1 Type
IE0                  BIT  TCON.1      ; Ext. Interrupt 0 Edge Flag
IT0                  BIT  TCON.0      ; Ext. Interrupt 0 Type

; TMR2CN 0xC8
TF2H                 BIT  TMR2CN.7    ; T2 High-Byte Overflow Flag
TF2L                 BIT  TMR2CN.6    ; T2 Low-Byte Overflow Flag
TF2LEN               BIT  TMR2CN.5    ; T2 Low Byte Interrupt Enable
TF2CEN               BIT  TMR2CN.4    ; T2 Input Capture Enable
T2SPLIT              BIT  TMR2CN.3    ; T2 Split-Mode Enable
TR2                  BIT  TMR2CN.2    ; Timer 2 On/Off Control
                                      ; bit 1 UNUSED
T2XCLK               BIT  TMR2CN.0    ; T2 External Clock Select
\ 
[then] \ ----------------------------------------------------------------------

0 [if] ------------------------[ unconverted ]---------------------------------
\ ACC         DATA     0E0H              ; Accumulator
------------------------------------------------------------------------ [then]
\ 
0 [if] \ ------------------------[ revisions ]---------------------------------
\ 
Date	   By  Comment
=======	=== ==================================================================
140422   rjn established as sfr85x_140422.fs -- should be same as the
            16Aug13 revision
16Aug13  rjn Converted C8051F850.INC, compared to sfr36x.fs
\ 
[then] \ ----------------------------------------------------------------------
