\ standalone_140726.fs -- standalone interpreter -- 140726rjn

0 [if]
Copyright (C) 2004-2006 by Charles Shattuck.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL information:   http://www.gnu.org/copyleft/lesser.txt

[then]
\ 
] here
\ 
\ : emit begin 1 .SCON0 until. 1 .SCON0 clr SBUF #! ;
\ : key  begin 0 .SCON0 until. 0 .SCON0 clr SBUF #@ ;
\ 
-: echo dup (emit) ;
\ 
-: space BL # (emit) ;
\ -: space lcd-space  ;  \ put space on LCD
\ 
-: cr 13 # (emit) 10 # (emit) ;
\ 
\ -----[ errors ]
\ :m err    [ 0 .p0 ] m;
\ -: led-on  [ err clr ] ;
\ 
\ err? is set/cleared on error, ok execution
cpuHere constant err? 1 cpuAllot  \ false=error, true=ok (low true)
\ 
\ accumulates errors until cleared
cpuHere constant #errs 1 cpuAllot  \ contains total error count
\ 
-: /err   $ff # err? #!  ;
-: !err     0 # err? #!  [ #errs inc ] ;  \ err? is low true
\ 
-: prompt  cr [ char > ] # (emit) ;
\ -: ok  cr
\   tib # a! @ 0=if drop prompt ; then drop 
\      err? #@   if drop prompt ; then drop  [ char ? ] # (emit) ;

\ changed so that char output is the same for ? and normal responses 140521rjn
-: (ok)   err? #@ 0=if drop [ char ? ] # (emit) SP0 SP! ; then drop space ;
-: ok  (ok) prompt ;      
\ 
-: 2dup |over |over ;
-: min 2dup swap
-: clip negate + -if push swap pop then 2drop ;
-: max 2dup clip ;
-: p |p ;

1 [if] \ ----------------------------------------------------------------------
-: @p |@p ;    
-: @p+ |@p+ ;  
\ -: depth [ SP0 -2 + ] # S #@ negate + ;
[then] \ ----------------------------------------------------------------------
\ 
-: depth S #@ invert ;
\ 
0 [if] \ patch suggestion from Charley
: this  ... ( stuff ) ... here ( *) nop nop nop ... ( stuff ) ... ;
( *) constant there
: that  ( stuff ) ;
here ( *) there org that ( *) org  \ put "that" stuff inside "this"
[then]

\ see job.fs to see how this is patched
-: huh?   here ( *) nop nop nop ;  constant patch-cold

-: ?stack   depth -if huh? ; then drop  ( depth if huh? ; then drop) ;
\ -: ?stack  depth 0=if drop ; then huh? ;

2 constant tib  \ begins after S, and A.

-: match ( ? - ?) @+ @p+ xor ior ;  \ 0 if still a match.
-: word 0 # tib # a! match match match match ;
\ -: ?digit [ char 0 negate ] # + -if huh? then -10 # + +if huh? then
\  10 # + ;
\ -: number tib # a! 0 # @+ 3 # min begin swap 10 # (*) @+ ?digit + swap
\ -: number tib # a! 0 # @+ 3 # min begin swap 10 # |* @+ ?digit + swap
\   1- 0=until drop ;
-: find @p if drop word if drop p+ p+ find ; then invert ; then drop
   0 # ;

here constant dict  \ Patch this later with real dictionary.
\ headers ] here [ dict org heads ##p! org ]  \ like this

-: dictionary 0 ##p! ;
-: interpret p push push a push dictionary find if
   drop @p+ @p pop a! pop pop p! push push ; then drop ( number)
   tib # a! @ if !err then drop  \ not found, ignore number, treat as error
   pop a! pop pop p! ;
-: tib! ( c) a push tib #@ 1+ tib #! tib # dup a! @ + 6 # min a! ! pop a! ;
-: 0tib tib # dup a! 0 # dup !+ dup !+ dup !+ dup !+ ! a! ;

true [if]
-: query 0tib
-: back key 8 # =if drop cr query ; then BL # max echo BL # xor if
   BL # xor tib! back ; then drop ;
-: quit /err  query interpret ?stack ok quit ;
[then]

\ Standalone Notes by rjn:
\ 1. The "BL # max" in back allows up to 32 chars as the tib count.
\ 2. The "BL # xor if" terminates input on a blank.
\ 3. The "BL # xor tib!" gets the char if it isn't a blank and puts
\    in the tib, updating the count in the first cell of tib ( i.e., tib).
\ 4. Each dictionary entry takes 6 bytes (cnt, 3 chars, 2 adr).
\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( standalone_140726.fs   ) . .( bytes) [else] drop [then] 
]
\
\
0 [if] ---------------------[ Revision History ]-------------------------------
\ 
Date	  By  Description
======= === ===================================================================
140726  rjn now clears stack on an error
\ 
[then] \ ----------------------------------------------------------------------
