\ temperature.fs -- DACS temperature commands -- 140923rjn
\
] here
\ 
0 [if] \ ------------------[ temperature calcs ]-------------------------------
\ 
1. The average temperature is calculated by (tavg) by accumulating 32
   readings in the prod register (used for multiply -- see multiply.fs).
   Each (rt) reading is added to the previous by (acc) which loads the prod
   register and adds it to the result register using result+prog .  Rounding
   by 0.5 degrees is performed by adding 16/2 to the result register

2. For debug, the accumulated count (in result) is saved off to the prod 
   register and can be displayed with total .  Note that total must be displayed
   immediately after tavg is computed because prod is also used for scaling.

3. (tcadj) subtracts the number of counts at zero degrees to give
   the total number of counts that must be offset.  See the following for how
   this is done. 140519rjn

4. Calculating degC per count:

   + The datasheet gives the sensor slope as 2.85 millivolts/degree C.
   + using 13-bits with a gain=0.5 and a reference of 1.65 Volts, 
     the full-scale voltage is 3.3/$2000 =  0.000402832 Volts/count 
                                         =~ 0.4028 mV/count .
   + slope = (2.85 mV/degC)/0.4028 mV/count = 7.074909 counts/degC
         and 
     degC/count = 1/slope = 0.141345 degC/count

   + slope variation is small (70 uV error out of 2.85 mV) but variations
     in the reference voltage (1.62 to 1.68 Volts) are significant.
     Individual chip calibration may be required.  140519rjn

6. To perfom a single-point calibration, see comment block below. 140519rjn

7. Another method using two readings:
      + With this calibration point, calculate another temperature
        point and use these two points for a temperature plot.
      + For example, the count for a temperature of 22.4 was measured at 1894.  
        Using 26 degrees C as my second point (arbitrary):
           - temperature difference = 26.0 - 22.4 = 3.6 degrees
             count at 26.0 degrees = 1894 + (3.6)(7.074909) = 1919
      + Using these two points and an appropriately scaled plot, draw a line
           between the two points and observe where the line crosses 
           the 0 degree C line.  Use the dacs_temp1.plt GNUplot plot file 
           and the dacs_temp1.dat data file, in the dacs directory, 
           to produce the plot.  Only two points need to be in the 
           data file: one for 22.4 degrees C and one for 26 degrees C.
      + Using this plot, observe that the counts/temperature line crosses at
        about 1734.  Because of the uncertainty in drawing the line, 
        the crossing value may have to be adjusted a few counts up or down 
        to get the best tracking.

8. (tcadj) subtracts the zero degree offset from the counts read from the
   temperature sensor (1734 = $06c6).

9. To calculate degrees C, subtract the offset and then apply the 
    degrees C per count factor, given as 1/slope above.  To get the best 
    accuracy, this fractional value is scaled up and then the number
    of digits and decimal point are determined after it is multiplied by
    the number of counts read from the temperature sensor.  The scaling
    is as follows:

      + degC/count = 1/slope = 0.141345 degC/count 
      + scaled multiplier for degrees C = 14134 = $3736

    Only the first five values are used but a larger number of digits can 
    be used if the decimal point is placed differently.

10. Water bath calcs using water bath zc=1747=$06d3
    sample calc: 
    deg. C/count=27.7/(reading-cz)=27.7/(1922-1747)=27.7/175
               =0.1582857 (use 15,829=$03dd5)
 
 temperature   reading   deg/count              multipliers
 B&K   Therm.            B&K         Therm.     B&K            Therm.
 ------------  -------   ---------------------- -----------------------------
 17.9  18.5    1857      0.16272727  0.16818182 16,273 ($3f91) 16,818 ($41b2)
 18.4  19.0    1861      0.16140351  0.16666667 16,140 ($3f0c) 16,667 ($411b)
 18.6  19.2    1862      0.16739130  0.16695652 16,739 ($4163) 16,696 ($4138)
 18.7  19.4    1863      0.16120689  0.16724137 16,121 ($3ef9) 16,724 ($4154)
 20.3  21.0    1873      0.16111111  0.16666667 16,111 ($3eef) 16,667 ($411b)
 20.8  21.5    1876      0.16124031  0.16666667 16,124 ($3efc) 16,667 ($411b)
 21.1  22.0    1879      0.15984848  0.16666667 15,985 ($3e71) 16,667 ($411b)
 22.9  23.8    1890      0.16013986  0.16643357 16,014 ($3e8e) 16,643 ($4103)
 23.3  24.0    1893      0.15958904  0.16438356 15,959 ($3e57) 16,438 ($4036)
 23.6  24.2    1895      0.15945946  0.16351351 15,946 ($3e4a) 16,351 ($3fdf)
 23.9  24.5    1897      0.15933333  0.16333333 15,933 ($3e3d) 16,333 ($3fcd)
 25.3          1907      0.15812500             15,812 ($3dc4)
 26.9          1917      0.15823529             15,824 ($3dd0)
 27.2          1919      0.15821395             15,814 ($3dc6)
 27.7          1922      0.15828571             15,829 ($3dd5)
 
 avg. B&K=$3f94  

 11. Note that the biggest factor affecting the temperature is not the zero
     crossing value (which can be measured rather easily), but the value
     for millivolts/count.  This depends on the "1.65 Volt" reference voltage
     which can vary considerably (1.62 to 1.68 Volts).  140519rjn
\ 
[then] \ ----------------------------------------------------------------------
\ 
0 [if] \ ----------------------------------------------------------------------

                         Single-Point Temperature Calibration

  1. The purpose of this calculation is to determine the count offset for a
     temperature of zero degrees Celsius and zero degrees Fahrenheit.
     This calculation is described in the datasheet but the procedure below
     calculates using A/D counts instead of millivolts.

  2.  temperature (degC) = [Vtemp (mV) - Voffset (mV)]/slope (mV/degC)
      
      A. Re-arranging for offset voltage: Voffset = Vtemp - (temperature)(slope)
      B. Converting Voffset to counts: 
            offset counts = (raw temp. counts) - (temp.)(slope)(counts/mV)

  3.  Example:
      
      A. I used the BK Precision meter with a Type "K" thermocouple, providing
         a readout to 0.1 degrees C.
         The accuracy is probably 0.5 degrees C, at best.
      B. Assume the thermocouple meter reading is 26.7 Degrees Celsius.  
         The "ts" command displays the corresponding raw temperature 
         reading as $0774 counts.
      C. With a reference voltage of 1.65102 Volts (inferred value:
            + mV/count = (3310.2 mV)/($2000 counts) = 0.404077 mV/count
            + counts/degC = (2.85 mV/degC)/(0.404077 mV/count) 
                          = 7.0531 counts/degC 
      D. Celsius offset counts = $0774 - (26.7 DegC)(7.0530588 counts/degC)
                               = $0774 - $bc = $06b8 (default used for tcz)

[then] \ ----------------------------------------------------------------------
\ 
\ 
-: ts-on  tsense-on  tsense-select  1 # |ms ;
\ -: (rt)   ( - d)   \ read temperature
\   tsense-select  ( tsense-on 1 # |ms)  ar  ( tsense-off) ;

\ : th  (rt) dh. ;   \ display temp in hex
\ : td  (rt) ud. ;   \ display temp in decimal 

\ -: ?display  ( d -)   hex? -if drop ud. ; then drop dh. ;
\ show single temperature count
-: ts  ts-on  ar  tsense-off  disable-adc  dh. space ;  \ raw temp. value
\ 
-: tr   \ display 32 consecutive readings
   ts-on  32 # 4 #for cr ar .d&h  1 # us  4 #next  disable-adc ;

\ -: (acc)  ( d --)   prod6 #!  prod7 #!  result+prod ;
\ -: @dresult  ( - d)   result7 #@  result6 #@ ;
\ -: !dresult  ( d -)   result6 #!  result7 #! ;

-: (tavg)   ( - d)   \ compute average of 32 readings
   0prod  0result  \ zero out prod and result registers
   ts-on
   32 # 4 #for ar (acc) 1 # us 4 #next      \ accumulate multiple readings in prod
   disable-adc
   0 # prod6 #!  8 # prod7 #!  result+prod  \ round by 0.5
   result>prod                              \ save acc. temperatures in prod
   5 # 4 #for result/2' 4 #next ;           \ divide acc. temp. in result by 32

\ -: .dres  @dresult ?display ;

-: tg  (tavg) .dresult ; 

\ adjust d1 by d2 to get total degrees from zero (account for negative too)
-: (adj)  ( d1 d2 -)   dnegate d+  -if dnegate 45 # emit then  !dresult ;
\ 
\ cpuHERE constant cz0 2 cpuALLOT  \ Celsius zero crossing, cz0 is msb
\ 
\ -: .cz  cz0 # @rd< ( .d&h) dh. ;  \ 140614rjn
\ 
-: (tcadj)  \ adjust temp for 0 degC result in result
   (tavg)  @dresult  cz0 # @rd< (adj) ;
\ 
-: (tc)   \ display degrees C (in prod) to a tenth of a degree 
\   (tcadj)  0scale  $37 # scale2 #!  $36 # scale3 #!  multiply ; ( toolstick)
\   (tcadj)  0scale  $3d # scale2 #!  $d5 # scale3 #!  multiply ; ( dacs0)
\   (tcadj)  0scale  $41 # scale2 #!  $1b # scale3 #!  multiply ; ( another chip)

\ This is the correct way to do it:
\ 3.3102/$2000 = 0.000404077
\ 2.85/0.40408 = 7.0530588 counts/degC
\ 1/7.0530588 = 0.141782456 degC/count  => scaling factor is 14178 = $3762
\ readings are good: 24.7 (B&K) vs. 24.5 (DACS)
   (tcadj)  0scale  $37 # scale2 #!  $62 # scale3 #!  multiply ;

-: descale15  15 #  4 #for prod/2' 4 #next ;

-: (tf)
\   (tcadj)  0scale $37 # scale2 #!  $62 # scale3 #! multiply
   (tc)  \ scaled degrees C in prod
\ add 4,000,000 (scaled value of 40) to result
   0result  $3d # result5 #!  $09 # result6 #! $00 # result7 #!  |prod+result 
\ multiply by 1.8 scaled by 2**15
   prod>result  0scale  $e6 # scale2 #!  $66 # scale3 #!  multiply 
   descale15  \ descale the result in prod by 2**15
\ subtract 40 again by adding its two's complement
   ff>result  $c2 # result5 #!  $f7 # result6 #! $00 # result7 #! 
   |prod+result ( results in prod) ; 

0 [if] \ -----[ old way: using separate tf zero crossing value ]---------------
\ 
cpuHERE constant fz0 2 cpuALLOT  \ Fahrenheit zero crossing, fz0 is msb
\ 
-: .fz  fz0 # .rd ;
: fz  $$  fz0 # !rd ;
\ 
\ calculate, load Fahrenheit zero crossing from Celsius value
: !fzero  [ cz0 1+ ] #@  cz0 #@ ( msb)  125 ## dnegate d+  fz0 # !rd ; 
-: (tfadj)  \ adjust temp for 0 deg F, result in result
   (tavg)  @dresult  fz0 # @rd< (adj) ;
\ 
-: (tf)  \ calc. degrees F (in prod) to a tenth of a degree
\   (tfadj)  0scale  $63 # scale2 #!  $d0 # scale3 #!  multiply ; ( one chip)
\ This is the correct way to do it:
   2.85/0.40408 = 7.0530588 counts/degC  ;  (5/9)(counts/degC) = 3.918..
   1/3.918... = 0.255208  => scaling factor is 25521 = $63b1
\ readings are ok: 76.3 (B&K) vs. 76.0 (DACS)
   (tfadj)  0scale  $63 # scale2 #!  $b1 # scale3 #!  multiply ;
\ 
[then] \ ----------------------------------------------------------------------
\
\ -: rspace  $20 # !rbuf ;
-: .t  5dp  6 # ?.rdigits  ;
\ -: tc  (tc)  .t rspace ;   
\ -: tf  (tf)  .t ;
-: tmp>rbuf   (tc) .t rspace (tf) .t  ( tc tf) ;
\ 
\ ----- conditional compilation summary -----
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( temperature.fs         ) . .( bytes) [else] drop [then] 
]
\ 
\ 
0 [if] ------------------------[ revisions ]-----------------------------------
\ 
Date	   By  Comment
=======	=== ===================================================================
140923   rjn temperature now put in rbuf
140614   rjn .cz now only displays in hex
140519   rjn now calculate degF from degC using calculation; removed code for
             calculatiing degF using separate zero crossing
140516   rjn corrected scaling, added simplified single point calibration 
140508   rjn changed averaging to 32, misc code cleanup.
140505   rjn changed tn command to ts (single temperature count)
09Nov13  rjn cleanup -- used analog simplifications, avg by 32 vs. 16
               Bumped up scaling for degrees F.  Perhaps offset needs adj.
07Nov13  rjn finished -- all agrees with the BK Precision meter
04Nov13  rjn used double number words for adjustments
03Nov13  rjn split out temperature.fs from adc-commands.fs.  All works!
24Oct13  rjn split out analog registers (now analog.fs)
22Oct13  rjn original version -- split out ADC words from commands.fs
\ 
[then] \ ----------------------------------------------------------------------


