\ tether_140502.fs -- bit-banged serial tethering -- 140502rjn

] here \ Target Forth, start marker
\ 
0 [if] \ -------------------[ bit-banged serial I/O ]--------------------------
\ 
1. Designed for use with the myforth one-wire tether, but code can be easily
   adapted for other applications requiring bit-banged serial I/O.
2. Words are named according to their use in the MOTE application.  Words
   starting with "i" are used on the intepose processor; words that start
   with "t" are executed on the target.
3. For example, "ik" and "tk" are serial key for the interposer and target,
   respectively.  Similarly, "ie" and "te" are the bit-banged emit words for
   the interposer and target.
4. The emit and key words for the target, "te" and "tk", perform I/O on the
   c2d line that is also used for bi-directional I/O with the C2 protocol.
5. Some words, such as "te", may have delays that are longer than strictly
   necessary to allow for completion of actions on the interposer (e.g.,
   immediately passing the byte back to the Host).  The "ie' and "te" words
   have ending delays to provide a stop bit -- these may extend the timing
   more than strictly needed for a bit-banged exchange but may be needed
   if interacting with a serial connection to a terminal or Host computer.
6. Timing is for a baud rate of 19.2K but can be easily adjusted for other
   rates by changing s-delay.
\ 
[then] \ ----------------------------------------------------------------------
\ 
\ -----[ bit timing ]
\ 
\ : osc  c2d-out  begin s-delay [ c2d toggle ] s1 0=until. ;
\ 
0 [if] \ ------------------[ precise timing ]----------------------------------
\ 
\ assumes 24.5 MHz internal clock
\ gives the precise timings for 19.2K, 52 usec/bit (4 bits=208us)
:m 488ns  1 # delay6 nop nop m;
:m sd/2  29 # |us  488ns 488ns m;  \ uses registers 6, 7
:m s-delay  sd/2 sd/2 m;
:m b-delay  8 # 5 #for s-delay 5 #next m;  \ byte delay
\ 
[then] \ ----------------------------------------------------------------------
\ 
1 [if] \ ----------------[ good enough timing ]--------------------------------
\ 
\ assumes 24.5 MHz internal clock
:m 408ns  1 # delay6 ( nop nop) m;  \ calculated, not measured)
\ making sd/2 callable vs. a macro adds ~ 320 ns per call (8x40 ns)
: sd/2  29 # |us  408ns 408ns ;  \ uses registers 6, 7
\ making s-delay an ajump vs. a macro adds 320 ns
: s-delay  sd/2 sd/2 ;
: b-delay  8 # 5 #for s-delay 5 #next ;  \ byte delay (lots of latitude here)
\ 
[then] \ ----------------------------------------------------------------------
\ 
\ -----[ ipp bit banged serial I/O ]
\ 
:m (iemit)  ( n -)  \ send lsb first
   8 # 5 #for  
      [ rrc c2d movcb ]  \ send lsb from T to c2d
      s-delay
   5 #next  drop m;
\ 
: ie  ( n --)  \ bit-banged serial emit
   c2d-out  [ c2d set ]  b-delay  ( allow target to complete)
            [ c2d clr ]  s-delay  ( start bit)
   (iemit)  [ c2d set ]  s-delay  ( stop bit) ;
\ 
:m i-high-wait  begin c2d until.    m;
:m i-low-wait   begin c2d 0=until.  m;

:m (ikey)  ( -- n)   \ assumes c2d high (from Target)
   0 #  
   8 # 5 #for
      s-delay
      [ c2d movbc rrc ]      \ send lsb from c to T
   5 #next m;
\ 
:m iok 7 # (emit) m;
\    
\ ipp key -- receive byte on ipp's c2d drive pin
\ : ik   c2d-in nop  i-high-wait i-low-wait  sd/2 (ikey) ;
\ 
1 [if] \ --------------[ timeout on high/low waits ]---------------------------
\ 
\ 1. provides a timeout of ~ 2 seconds for high and low waits
\ 2. Can't use a timer because of interference with c2 I/O.
\ 
cpuHere constant todh 2 cpuAllot  \ double number timeout delay
:m todl  [ todh 1+ ] m;  \ tod lsb ( msb is todh)

:m !tod  ( d -)  todh #!  todl #! m;
:m @tod  ( - d)  todl #@  todh #@ m;  \ msb on tos, as it should be!
:m tod-   @tod -1 ## |d+ !tod m;
:m -tod?  ( - n)  @tod ior m;
\ timeout =~ 210 ms
:m /tod   $ffff ## !tod m;
\ 
\ -: ihw   c2d if. ; then  tod- -tod? 0=if drop ; then drop ihw ;
:m (ihwait)  begin   c2d if. ; then tod- -tod? 0=if drop ; then drop again m;
:m (ilwait)  begin c2d 0=if. ; then tod- -tod? 0=if drop ; then drop again m;

-: ihw  c2d   if. ; then  /tod (ihwait) ;
-: ilw  c2d 0=if. ; then  /tod (ilwait) ;

5 constant tmult-min
cpuHere constant tmult  1 cpuAllot  \ timeout multiplier (times 208 ms)

\ e.g., to change at ipp command line (target talking): 10 # !tmult
-: !tmult  ( n -)  tmult #! ;
-: /tmult  tmult-min #  !tmult ;  \ put in initialization!
-: @tmult  tmult #@   tmult-min # negate +  -if drop /tmult ; then drop ;

-: ihwait  10 #  4 #for ihw 4 #next ;  \ default 2 second t/o
-: ilwait  10 #  4 #for ilw 4 #next ;  \ default 2 second t/o

: ik   c2d-in nop  ihwait  ilwait  
   -tod? 0=if drop iok ; then drop sd/2 (ikey) ;
\ 
[then] \ ----------------------------------------------------------------------
\    
\ -----[ target bit banged serial I/O ]
\ 
:m (temit)  ( n -)  \ send lsb first  -- "bit banged" emit 
   8 # 5 #for  
      [ rrc tc2d movcb ]      \ send lsb from T to c2d
      s-delay
   5 #next   drop m;
\ 
: te  ( n --)  \ Target bit-banged emit
   tc2d-out  [ tc2d set ]  b-delay ( allow iip to finish Host xmsn)  
             [ tc2d clr ]  s-delay ( start bit) 
   (temit)   [ tc2d set ]  s-delay ( stop bit) ;
\ 
:m t-high-wait  begin tc2d until.    m;
:m t-low-wait   begin tc2d 0=until.  m;
\ 
:m (tkey)  ( -- n)   \ assumes c2d high (from Target)
   0 #  
   8 # 5 #for
      s-delay
      [ tc2d movbc rrc ]      \ send lsb from c to T
   5 #next m;
\ 
\ Target key: receive byte on Target's c2d (tc2d)
: tk  tc2d-in nop  t-high-wait  t-low-wait  sd/2 (tkey) ;
\ 
\ 
0 [if] \ -------------------[ ipp and Target quit ]----------------------------
\ 
1. iq is a modified version of the original Target quit for execution on the
   ipp.  It receives execution vectors sent from the Host and passes them on
   to the Target.
2. iq can escape back to the ipp standalone interpreter when the Host sends a
   handshaking byte of $ff.  After exiting iq, the Host 
   can send commands to the ipp interpreter (e.g., to reset the Target).
3. iq is executed as a command from the Host.
4. Thus, when the Host is talking, it sends execution vectors to the ipp, 
   executing in the iq loop.
\ 
[then] \ ----------------------------------------------------------------------
\ 
[ \ Gforth
: tq   [char] t emit-s  [char] q emit-s  isend ;  \ Target quit (execute on Target)
: iq   [char] i emit-s  [char] q emit-s  isend ;
] \ myforth
\ 
\ -----[ target quit ]
\ 
: tok  7 #  te ;
-: tex   push push ;  \ target execute
\ 
: tq  tk tk tex tok tq ;
\ 
: tnumber 5 # te  tk ;
\ 
\ : stst  [ char b ] # te  [ char o ] # te  [ char b ] # te  tok ;
\ 
\ 
\ -----[ interposer quit ]
\ 
\ :m iok 7 # (emit) m;
\ 
\ target response processing --
\ 
\ 7 -- normal action: pass to Host
\ 5 -- waiting for byte (e.g., number)
\ 
: ?response  ik
    7 # xor 0=if drop iok                   ; then 7 # xor 
    5 # xor 0=if drop iok key ie ( ik drop) ; then 5 # xor
    (emit) ?response ;
\ 
: iq  key dup (emit) if drop ; then drop  key key ie ie ?response iq ;
\ 
1 [if] \ ---------------------[ target utilities ]-----------------------------
\ 
:m tser-type ( da) p! |@p+ begin |@p+ te 1- 0=until drop m;
:m " 34 parse here there place here there [ c@ 1 + ] allot m;
-: tstring pop pop swap tser-type ;

-: (tdigit)   -10 # + -if -39 # + then 97 # + ;  
-: tdigit  (tdigit) te ;
-: tspace  $20 # te ;
-: tcrlf     $0d # te  $0a # te ;

\ -: dsplit  ( n -)   16 # |u/mod ;
-: thd-      ( dsplit) 16 # |u/mod  tdigit tdigit ;
-: (th$)   [ char $ ] # te  thd- ;
-: thdigit  (th$) tspace ;
-: .mt$  tstring " empty "
: .tempty  .mt$ ;

-: .>  [ char > ] # te  tspace ;
-: (.ts)    S #@ a! begin @+ a 0=if 2drop ; then drop thdigit again

-: .ts  depth 0=if drop .tempty ; then thdigit .> (.ts) ;

-: serr$  tstring " needs a start adr "
-: .serr  serr$ ;

\ m: 2dup  |over  |over ;
-: tdump  ( d -)  depth -2 # + -if drop .serr ; then drop
   2dup  p! tcrlf (th$) thd-  .> 16 # 4 #for |@p+ thdigit 4 #next ;
\ 
[then] \ -----------------------------------------------------------------------
\ 
1 [if] \ ---------------------[ target test words ]----------------------------
\ 
[ \ Gforth
\ assumes byte to be sent is on the ipp stack
: ie   [char] i emit-s  [char] e emit-s  isend ;  \ ipp serial emit
: ik   [char] i emit-s  [char] k emit-s  isend ;  \ ipp serial key
\ 
: te   [char] t emit-s  [char] e emit-s  isend ;  \ target serial emit
: tk   [char] t emit-s  [char] k emit-s  isend ;  \ target serial key
\ 
\ : t88  [char] t emit-s  [char] 8 dup emit-s emit-s  isend ;  \ test t/o
\ 
] \ myforth
\ 
-: xxx t11 ;
\ 
:m 1sec  250 # ms  250 # ms  250 # ms  250 # ms  m;
-: xyz t11 1sec t11 ;
\ : s17-wait  s17 if. ; then  tod- -tod? 0=if drop ; then drop s17-wait ;
\ : t88   [ char b ] #  [ char z ] #
\   begin  t11 /tod s17-wait s21 0=until. ; \ test t/o delay
\ 
[then] \ ----------------------------------------------------------------------
\ 
\ -------------------------[ tethering control ]-------------------------------
\ 
[ : targeting  postpone [ iq target talking ; immediate ]
[ : posing    0 talks !  $ff emit-s  key-s drop  postpone [ ; immediate ]
\ 
here ( stop marker) [ swap -  ( -- n)
cs? [if] cr .( tether_140502.fs ) . .( bytes) [else] drop [then]
]
\ 
0 [if] --------------------------[ revisions ]---------------------------------
\ 
Date	   By  Comment
=======	=== ==================================================================
140502   rjn added revision date and copied to system
\ 
[then] \ ----------------------------------------------------------------------
