\ xcells_140502.fs -- fetch, store & display multiple cells -- 140502rjn
\ 
] ( target forth)  here  ( * start)
\ 
\ -----[ set & get cells ]
\ 
:m |(!cells)  [ 4 push ] 4 #for !+ 4 #next [ 4 pop ] m;
-: (!cells)  |(!cells) ;

:m |!cells   ( ... adr n -)  swap a!  |(!cells)  m;
-: !cells  |!cells ;

:m |(@cells)  [ 4 push ] 4 #for @+ 4 #next [ 4 pop ] m;

:m |@cells   ( adr n - ...)  swap a!  |(@cells)  m;
-: @cells  |@cells ;

-: (@cells<)  [ 4 push ] 4 #for @  [ 1 dec ] 4 #next [ 4 pop ] ;
-: @cells<  ( adr n - ...)  swap |over -1 # + + a!  (@cells<) ;

1 [if] \ ----------------------------------------------------------------------
\
\ -: msb$   string " > "
\ -: .msb  msb$ ;
\ display in hex left to right (lsb is rightmost, like h.s)
\ : (qh.) ( q --)    h. h. h. h. ;  
-: qh.   ( q --)    ( .msb) h. h. h. h. ;

\ fetch and store with msb on tos (normal)
\ -: @dq   ( n -- dq)   8 # @cells ; \ lsb on tos
-: @dq<  ( n -- dq)   8 # @cells< ;  \ msb on tos
-: !dq   ( dq n - )   8 # !cells ;
-: .dq   ( n --)   @dq< qh. qh. ;

-: @quad   ( n - q)    4 # @cells  ; \ result: lsB on tos
-: @quad<  ( n - q)    4 # @cells< ; \ result: msB on tos
-: !quad  ( q n -)     4 # !cells  ; \ msb on tos
-: .quad  ( q n -)      @quad< qh. ;

\ use "r" to signify direct cell "registers" 
-: @rd   ( a - d)    2 # @cells  ; 
-: @rd<  ( a - d)    2 # @cells< ; 
-: !rd   ( a -)      2 # !cells  ; 
-: .rd   ( a -)      @rd< dh. ;

-: .pent  ( p n -)   5 # @cells< h. qh. ;     
\ 
[then] \ ----------------------------------------------------------------------
\   
\ conditional compilation summary
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( xcells_140502.fs       ) . .( bytes) [else] drop [then]
]
\ 
0 [if] \ -----------------------[ revisions ]-----------------------------------

Date	   By  Comment
=======	=== ===================================================================
140502   rjn added conditional comp. summary,
             added rev number and put in library
02Dec13  rjn added double words
19Jan13  rjn added .pent
10Sep12  rjn misc. cleanup, removed some defs from standalone dictionary
03Sep12  rjn eliminated the ">" indicator
16Jan12  rjn added compilation calc. (copied from WARB4)
15May09  rjn      fixed @cells<
12May09  rjn      original version, taken out of registers.fs
\ 
[then] \ -----------------------------------------------------------------------
