\ xram_buffer.fs -- gp ram buffer -- 140826rjn
\ 
] here ( *start)

0 [if] \ -----------------------[ Notes ]--------------------------------------
\ 
1. Clipped to $3f, max size of 4432 fifo buffer
2. Change /rbuf to set start of buffer to any place in xram (0 for now)
\ 
[then] \ ----------------------------------------------------------------------

cpuHere constant rbuf_offset 1 cpuAllot  \ current offset within ram buffer

-: !r>  ( n -)   rbuf_offset #! ;
-: /rbuf  0 # !r> ;  \ can start anywhere in xram
-: rbuf+  [ rbuf_offset inc ] ; \ can exceed cliped size!
:m rclip  ( n - n')   $3f # and m;
-: #rbuf  rbuf_offset #@ ;  \ not clipped -- do in user words
\ -: .#rbuf  #rbuf h. space ;
-: >rbuf  #rbuf 0 #  p! ;
-: !rbuf   ( n -)   >rbuf  !x  rbuf+ ;
-: @rbuf   ( - n)   >rbuf  @x  rbuf+ ;
-: (@rbuf-)  ( offset - n)   -if 0 # ; then 0 # p! @x ;
-: #rbuf-   #rbuf 1- ;
-: #rbuf--  #rbuf 1- 1- ;
-: @rbuf-  ( - n)   #rbuf-  (@rbuf-) ;  \ last byte written
-: @rbuf-- ( - n)   #rbuf-- (@rbuf-) ;  \ next to last byte written
\ 
-: |h   ( n -)  'bar h. ;
-: |h|  ( n -)  |h 'bar ;
\ 
\ display only ascii, show highlighted ? if not ascii 
-: ?.  ( n -)   dup $1f # <if drop drop '!? ; then drop
                dup $7e # <if drop emit ; then drop drop '!? ;

-: (.rbuf)  ( n -)  
   1- 1- 2 # max  /rbuf  5 #for @rbuf ?. 5 #next rbuf+ rbuf+ ;
: .rbuf  #rbuf rclip if (.rbuf) ; then drop ;  

-: (h.rbuf)  ( n -)   
   dup h. space  /rbuf  5 #for @rbuf |h  5 #next ;
-: h.rbuf  #rbuf rclip if (h.rbuf) ; then drop ;

\ if using min, take care.  A negative value is not treated as less than 0
\ : 0rjn  $3e #  $3f # min ;  \ $3e
\ : 1rjn  $3f #  $3f # min ;  \ $3f
\ : 2rjn  $40 #  $3f # min ;  \ $3f
\ : 3rjn  $80 #  $3f # min ;  \ $3f ?
\ : 4rjn  $80 #    0 # max ;  \ 0
\ : 5rjn  $80 #    0 # min ;  \ 0 ?      
\ 
\ -----[ conditional compilation summary ]
here [ swap -  ( -- n)
\              ......................321
cs? [if] cr .( xram_buffer.fs         ) . .( bytes) [else] drop [then] 
]
\
\
0 [if] ---------------------[ Revision History ]-------------------------------
\ 
Date	  By  Description
======= === ===================================================================
140826  rjn added #rbuf- & #rbuf--, fixed stack err on (@rbuf-).
140823  rjn removed !r> from .rbuf and h.rbuf -- @rbuf increments the pointer
140813  rjn eliminated "min" and separated out buffer display words
140802  rjn changed rbuf_emit to .rbuf
140801  rjn initial version
\ 
[then] \ ----------------------------------------------------------------------
